const {
    DataTypes
} = require('sequelize');
module.exports = (sequelize) => {
    return sequelize.define('Auditoria', {
        id: {
            type: DataTypes.INTEGER,
            primaryKey: true,
            autoIncrement: true
        },
        UsuarioId: {
            type: DataTypes.INTEGER,
            references: {
                model: 'Usuarios',
                key: 'id'
            }
        },
        Registroid: {
            type: DataTypes.INTEGER,
            allowNull: true,
        },
        Accion: {
            type: DataTypes.STRING,
            allowNull: true,
        },
        Tabla: {
            type: DataTypes.STRING,
            allowNull: true,
        },
        Resumen: {
            type: DataTypes.STRING,
            allowNull: true,
        },
        Detalle: {
            type: DataTypes.TEXT,
            allowNull: true,
        },
        Interaccion: {
            type: DataTypes.DATE,
            allowNull: true,
        },
        
    });
}