const {
    DataTypes
} = require('sequelize');

module.exports = (sequelize) => {
    return sequelize.define('Consultorio', {
        id: {
            type: DataTypes.INTEGER,
            autoIncrement: true,
            primaryKey: true
        },
        Nombre: {
            type: DataTypes.STRING,
            allowNull: false,
        },
        FotoConsultorio: {
            type: DataTypes.STRING,
            allowNull: false
        },
        ServicioId: {
            type: DataTypes.INTEGER,
            references: {
                model: 'Servicios',
                key: 'id'
            }
        },
        SedeId: {
            type: DataTypes.INTEGER,
            references: {
                model: 'Sedes',
                key: 'id'
            }
        }
    });
};