const {
    DataTypes
} = require('sequelize');

module.exports = (sequelize) => {
    return sequelize.define('DienteEconomico', {
        id: {
            type: DataTypes.INTEGER,
            primaryKey: true,
            autoIncrement: true
        },
        TextoRojo: {
            type: DataTypes.STRING,
            allowNull: false
        },
        TextoAzul: {
            type: DataTypes.STRING,
            allowNull: false
        },
        Nombre: {
            type: DataTypes.TEXT,
            allowNull: false
        },
        NumeroDental: {
            type: DataTypes.TEXT,
            allowNull: false
        },
        FondoDental: {
            type: DataTypes.TEXT,
            allowNull: false
        },
        CarieDental: {
            type: DataTypes.TEXT,
            allowNull: false
        },
        EstadoDiente: {
            type: DataTypes.TEXT,
            allowNull: false
        },
        TipoDienteId: {
            type: DataTypes.INTEGER,
            references: {
                model: 'TipoDientes',
                key: 'id'
            }
        },
        UbicacionId: {
            type: DataTypes.INTEGER,
            references: {
                model: 'Ubicacions',
                key: 'id'
            }
        },
        CuadranteId: {
            type: DataTypes.INTEGER,
            references: {
                model: 'Cuadrantes',
                key: 'id'
            }
        },
        OdontogramaId: {
            type: DataTypes.INTEGER,
            references: {
                model: 'OdontogramaEconomicos',
                key: 'id'
            }
        }
    });
}