const {
    DataTypes
} = require('sequelize');

module.exports = (sequelize) => {
    return sequelize.define('Documento', {
        id: {
            type: DataTypes.INTEGER,
            autoIncrement: true,
            primaryKey: true
        },
        NombreTrabajador: {
            type: DataTypes.STRING,
            allowNull: false
        },
        NombreArchivo: {
            type: DataTypes.STRING,
            allowNull: false
        },
        DescripcionBreve: {
            type: DataTypes.STRING,
            allowNull: false
        },
        FechaSubida: {
            type: DataTypes.DATE,
            allowNull: false
        },
        RutaArchivo: {
            type: DataTypes.STRING,
            allowNull: false
        },
        TipoDocPDFId: {
            type: DataTypes.INTEGER,
            references: {
                model: 'TipoDocPDFs',
                key: 'id'
            }
        },
        UsuarioId: {
            type: DataTypes.INTEGER,
            allowNull: false
        }
    });
};