const {
    DataTypes
} = require('sequelize');

module.exports = (sequelize) => {
    return sequelize.define('Egreso', {
        id: {
            type: DataTypes.INTEGER,
            primaryKey: true,
            autoIncrement: true
        },
        FechaRegistro: {
            type: DataTypes.DATE,
            allowNull: false
        },
        // que se pago
        Nombre: {
            type: DataTypes.STRING,
            allowNull: false
        },
        // a quien va el pago
        Proveedor: {
            type: DataTypes.STRING,
            allowNull: false
        },
        // detalles sobre el pago realizado
        Detalles: {
            type: DataTypes.STRING,
            allowNull: false
        },
        NroFactura: {
            type: DataTypes.STRING,
            allowNull: false
        },
        MontoSoles: {
            type: DataTypes.DECIMAL(10, 2),
            allowNull: false
        },
        MontoDolares: {
            type: DataTypes.DECIMAL(10, 2),
            allowNull: false
        },
        SedeId: {
            type: DataTypes.INTEGER,
            allowNull: false
        },
        // usuario que registra
        UsuarioId: {
            type: DataTypes.INTEGER,
            allowNull: false
        }
    });
};