const {
    DataTypes
} = require('sequelize');

module.exports = (sequelize) => {
    return sequelize.define('EncuestaCompleja', {
        id: {
            type: DataTypes.INTEGER,
            autoIncrement: true,
            primaryKey: true
        },
        Fecha: {
            type: DataTypes.DATE,
            allowNull: false
        },
        CondicionPaciente: {
            type: DataTypes.STRING,
            allowNull: false
        },
        Instalaciones: {
            type: DataTypes.STRING,
            allowNull: false
        },
        AtencionRecepcion: {
            type: DataTypes.STRING,
            allowNull: false
        },
        AtencionServicio: {
            type: DataTypes.STRING,
            allowNull: false
        },
        Valores: {
            type: DataTypes.STRING,
            allowNull: false
        },
        TiempoEspera: {
            type: DataTypes.STRING,
            allowNull: false
        },
        OdontologoClaro: {
            type: DataTypes.STRING,
            allowNull: false
        },
        OdontologoServicio: {
            type: DataTypes.STRING,
            allowNull: false
        },
        Cita: {
            type: DataTypes.STRING,
            allowNull: false
        },
        OdontologoAtendioQUIEN: {
            type: DataTypes.STRING,
            allowNull: false
        },
        AtencionOdontologo: {
            type: DataTypes.STRING,
            allowNull: false
        },
        AtencionTecnico: {
            type: DataTypes.STRING,
            allowNull: false
        },
        SolucionProblema: {
            type: DataTypes.STRING,
            allowNull: false
        },
        Gusto: {
            type: DataTypes.STRING,
            allowNull: false
        },
        Sugerencia: {
            type: DataTypes.STRING,
            allowNull: false
        },
        Recomendaria: {
            type: DataTypes.STRING,
            allowNull: false
        }
    });
};