const {
    DataTypes
} = require('sequelize');

module.exports = (sequelize) => {
    return sequelize.define('EnfermedadActual', {
        id: {
            type: DataTypes.INTEGER,
            primaryKey: true,
            autoIncrement: true
        },
        MotivoConsulta: {
            type: DataTypes.STRING,
            allowNull: false
        },
        TiempodeEnfermedad: {
            type: DataTypes.STRING,
            allowNull: false
        },
        SignosySintomasPrincipales: {
            type: DataTypes.STRING,
            allowNull: false
        },
        RelatoCronologico: {
            type: DataTypes.STRING,
            allowNull: false
        },
        FuncionesBiologicas: {
            type: DataTypes.STRING,
            allowNull: false
        },
        AgendamientoId: {
            type: DataTypes.INTEGER,
            allowNull: false
        },
        PacienteId: {
            type: DataTypes.INTEGER,
            references: {
                model: 'Pacientes',
                key: 'id'
            }
        }
    });
}