const {
    DataTypes
} = require('sequelize');

module.exports = (sequelize) => {
    return sequelize.define('EstadoDiente', {
        id: {
            type: DataTypes.INTEGER,
            primaryKey: true,
            autoIncrement: true
        },
        Imagen: {
            type: DataTypes.STRING,
            allowNull: false
        },
        Magnitud: {
            type: DataTypes.INTEGER,
            allowNull: false // 1 -> Grande // 2 -> Pequeño
        },
        Posicion: {
            type: DataTypes.INTEGER,
            allowNull: false // 1 -> Superior // 2 -> Inferior
        },
        HallazgoId: { // los hallazgos segun NT 188 - 2022 - MINSA
            type: DataTypes.INTEGER,
            references: {
                model: 'Hallazgos',
                key: 'id'
            }
        }
    });}