const {
    DataTypes
} = require('sequelize');

module.exports = (sequelize) => {
    return sequelize.define('Evolucion', {
        id: {
            type: DataTypes.INTEGER,
            primaryKey: true,
            autoIncrement: true
        },
        FechaEvolucion: {
            type: DataTypes.DATE,
            allowNull: false
        },
        Descripcion: {
            type: DataTypes.TEXT,
            allowNull: false
        },
        CodigoProcedimiento: {
            type: DataTypes.STRING,
            allowNull: false
        },
        NombreProcedimiento: {
            type: DataTypes.STRING,
            allowNull: false
        },
        CodigoCIE10: {
            type: DataTypes.STRING,
            allowNull: false
        },
        DiagnosticoCIE10: {
            type: DataTypes.STRING,
            allowNull: false
        },
        AgendamientoId: {
            type: DataTypes.INTEGER,
            allowNull: false
        },
        PacienteId: {
            type: DataTypes.INTEGER,
            references: {
                model: 'Pacientes',
                key: 'id'
            }
        }
    });
}