const {
    DataTypes
} = require('sequelize');

module.exports = (sequelize) => {
    return sequelize.define('ExploracionFisica', {
        id: {
            type: DataTypes.INTEGER,
            primaryKey: true,
            autoIncrement: true
        },
        FrecuenciaCardiaca: {
            type: DataTypes.STRING,
            allowNull: false
        },
        FrecuenciaRespiratoria: {
            type: DataTypes.STRING,
            allowNull: false
        },
        PresionArterial: {
            type: DataTypes.STRING,
            allowNull: false
        },
        Temperatura: {
            type: DataTypes.STRING,
            allowNull: false
        },
        SaturaciondeOxigeno: {
            type: DataTypes.STRING,
            allowNull: false
        },
        ExamenClinicoGeneral: {
            type: DataTypes.STRING,
            allowNull: false
        },
        OdontoEstomatologia: {
            type: DataTypes.STRING,
            allowNull: false
        },
        AgendamientoId: {
            type: DataTypes.INTEGER,
            allowNull: false
        },
        PacienteId: {
            type: DataTypes.INTEGER,
            references: {
                model: 'Pacientes',
                key: 'id'
            }
        }        
    });
}