const {
    DataTypes
} = require('sequelize');

module.exports = (sequelize) => {
    return sequelize.define('Factura', {
        id: {
            type: DataTypes.INTEGER,
            primaryKey: true,
            autoIncrement: true
        },
        FechaFacturacion: {
            type: DataTypes.DATE,
            allowNull: false
        },
        NombreIAFA: {
            type: DataTypes.STRING,
            allowNull: false
        },
        NombreEmpresa: {
            type: DataTypes.STRING,
            allowNull: false
        },
        NombrePaciente: {
            type: DataTypes.STRING,
            allowNull: false
        },
        NombreOdontologo: {
            type: DataTypes.STRING,
            allowNull: false
        },
        CopagoFijo: {
            type: DataTypes.STRING,
            allowNull: false
        },
        Copagovariable: {
            type: DataTypes.STRING,
            allowNull: false
        },
        CantidadDeducible: {
            type: DataTypes.INTEGER,
            allowNull: false
        },
        DeducibleUnitario: {
            type: DataTypes.DECIMAL(10, 2),
            allowNull: false
        },
        DeducibleTotal: {
            type: DataTypes.DECIMAL(10, 2),
            allowNull: false
        },
        SubTotalVerdadero: {
            type: DataTypes.DECIMAL(10, 2),
            allowNull: false
        },
        SubTotalaPagar: {
            type: DataTypes.DECIMAL(10, 2),
            allowNull: false
        },
        Descuento: {
            type: DataTypes.DECIMAL(10, 2),
            allowNull: false
        },
        SubTotal: {
            type: DataTypes.DECIMAL(10, 2),
            allowNull: false
        },
        IGV: {
            type: DataTypes.DECIMAL(10, 2),
            allowNull: false
        },
        Total: {
            type: DataTypes.DECIMAL(10, 2),
            allowNull: false
        },
        // monto que se pagara en soles
        MontoaPagar: {
            type: DataTypes.DECIMAL(10, 2),
            allowNull: false
        },
        // monto que se pagara en soles
        MontoPagado: {
            type: DataTypes.DECIMAL(10, 2),
            allowNull: false
        },
        // monto faltante a pagar en soles
        MontoRestante: {
            type: DataTypes.DECIMAL(10, 2),
            allowNull: false
        },
        // pendiente, pagado, reeebolso y parcial
        EstadoPagoId: {
            type: DataTypes.INTEGER,
            allowNull: false
        },
        SedeId: {
            type: DataTypes.INTEGER,
            allowNull: false
        },
        UsuarioId: {
            type: DataTypes.INTEGER,
            allowNull: false
        },
        PersonalId: {
            type: DataTypes.INTEGER,
            allowNull: false
        },
        PacienteId: {
            type: DataTypes.INTEGER,
            allowNull: false
        },
        IAFAId: {
            type: DataTypes.INTEGER,
            allowNull: false
        }
    });
}