const {
    DataTypes
} = require('sequelize');

module.exports = (sequelize) => {
    return sequelize.define('Incidencia', {
        id: {
            type: DataTypes.INTEGER,
            autoIncrement: true,
            primaryKey: true
        },
        Codigo: {
            type: DataTypes.STRING,
            allowNull: false
        },
        Descripcion: {
            type: DataTypes.STRING,
            allowNull: false
        },
        FechaIncidente: {
            type: DataTypes.DATE,
            allowNull: false
        },
        FechaRegistro: {
            type: DataTypes.DATE,
            allowNull: false
        },
        DOCPersonal: {
            type: DataTypes.STRING,
            allowNull: false
        },
        Personal: {
            type: DataTypes.STRING,
            allowNull: false
        },
        SedeId: {
            type: DataTypes.INTEGER,
            allowNull: false
        },
        EstadoId: {
            type: DataTypes.INTEGER,
            references: {
                model: 'EstadoIncidencia',
                key: 'id'
            }
        },
        TipoIncidenciaId: {
            type: DataTypes.INTEGER,
            references: {
                model: 'TipoIncidencia',
                key: 'id'
            }
        },
        ClienteId: {
            type: DataTypes.INTEGER,
            references: {
                model: 'Clientes',
                key: 'id'
            }
        },
    });
};