const {
    DataTypes
} = require('sequelize');

module.exports = (sequelize) => {
    return sequelize.define('IncidenciaDetalle', {
        id: {
            type: DataTypes.INTEGER,
            autoIncrement: true,
            primaryKey: true
        },
        QuePaso: {
            type: DataTypes.STRING,
            allowNull: false
        },
        QuienProboco: {
            type: DataTypes.STRING,
            allowNull: false
        },
        CuandoPaso: {
            type: DataTypes.STRING,
            allowNull: false
        },
        DondePaso: {
            type: DataTypes.STRING,
            allowNull: false
        },
        Causa: {
            type: DataTypes.STRING,
            allowNull: false
        },
        Responsable: {
            type: DataTypes.STRING,
            allowNull: false
        },
        Observaciones: {
            type: DataTypes.STRING,
            allowNull: false
        },
        Seguimiento: {
            type: DataTypes.STRING,
            allowNull: false
        },
        FechaCumplimiento: {
            type: DataTypes.DATE,
            allowNull: false
        },
        Verificacion: {
            type: DataTypes.STRING,
            allowNull: false
        },
        Procede: {
            type: DataTypes.STRING,
            allowNull: false
        },
        AccionaTomar: {
            type: DataTypes.STRING,
            allowNull: false
        },
        IncidenciaId: {
            type: DataTypes.INTEGER,
            references: {
                model: 'Incidencia',
                key: 'id'
            }
        }
    });
};


