const { Sequelize } = require('sequelize');
require('dotenv').config();
const sequelize = new Sequelize(
  process.env.DB_URL, 
  {
    dialect: "postgres",
    logging: false,
  }
);
// modelos generales
const EstadoAgendamiento = require('./estadoagendamiento.model')(sequelize);
const EstadoIncidencia = require('./estadoincidencia.model')(sequelize);
const EstadoCampania = require('./estadocampania.model')(sequelize);
const EstadoOrdenLaboratorio = require('./estadoordenlaboratorio.model')(sequelize);
const EstadoPago = require('./estadopago.model')(sequelize);
const EstadoUsuario = require('./estadousuario.model')(sequelize);
const FuenteCaptacion = require('./fuentecaptacion.model')(sequelize);
const Genero = require('./genero.model')(sequelize);
const GradoInstruccion = require('./gradoinstruccion.model')(sequelize);
const Relacion = require('./relacion.model')(sequelize);
const Vinculacion = require('./vinculacion.model')(sequelize);
const TipoActividad = require('./tipoactividad.model')(sequelize);
const TipoCampania = require('./tipocampania.model')(sequelize);
const TipoAfiliacion = require('./tipoafiliacion.model')(sequelize);
const TipoDocumento = require('./tipodocumento.model')(sequelize);
const TipoIncidencia = require('./tipoincidencia.model')(sequelize);
const TipoRespuesta = require('./tiporespuesta.model')(sequelize);
const TipoIngreso = require('./tipoingreso.model')(sequelize);
const TipoProveedor = require('./tipoproveedor.model')(sequelize);
const TipoPago = require('./tipopago.model')(sequelize);
const Periodo = require('./periodo.model')(sequelize);
const Hallazgo = require('./hallazgo.model')(sequelize);
const Categoria = require('./categoria.model')(sequelize);
// modelos para datos de la empresa
const Iafa = require('./iafa.model')(sequelize);
const TipoUsuario = require('./tipousuario.model')(sequelize);
const Servicio = require('./servicio.model')(sequelize);
const Profesion = require('./profesion.model')(sequelize);
const CargoUsuario = require('./cargousuario.model')(sequelize);
const Empresa = require('./empresa.model')(sequelize);
const Sede = require('./sede.model')(sequelize);
const Consultorio = require('./consultorio.model')(sequelize);
// modelos para seguimiento de incidencias
const Cliente = require('./cliente.model')(sequelize);
const Incidencia = require('./incidencia.model')(sequelize);
const IncidenciaDetalle = require('./incidenciadetalle.model')(sequelize);
const Accion = require('./accion.model')(sequelize);
// modelos para las encuestas de satisfacción
const EncuestaSimple = require('./encuestasimple.model')(sequelize);
const EncuestaKids = require('./encuestakids.model')(sequelize);
const EncuestaCompleja = require('./encuestacompleja.model')(sequelize);
// tablas de agendamiento
const Usuario = require('./usuario.model')(sequelize);
const Paciente = require('./paciente.model')(sequelize);
const Ubicacion = require('./ubicacion.model')(sequelize);
const Agendamiento = require('./agendamiento.model')(sequelize);
const Familiar = require('./familiar.model')(sequelize);
const Covertura = require('./covertura.model')(sequelize);
const Atiende = require('./atiende.model')(sequelize);
const Auditoria = require('./auditoria.model')(sequelize);
// modelos rrhh
const Evaluacion = require('./evaluacion.model')(sequelize);
const HistorialLaboral = require('./historiallaboral.model')(sequelize);
const Pago = require('./pago.model')(sequelize);
const TipoDocPDF = require('./tipodocpdf.model')(sequelize);
const Documento = require('./documento.model')(sequelize);
// modelos patrimonio
const CategoriaPatrimonio = require('./categoriapatrimonio.model')(sequelize);
const SubCategoriaPatrimonio = require('./subcategoriapatrimonio.model')(sequelize);
const Patrimonio = require('./patrimonio.model')(sequelize);
const Movimiento = require('./movimiento.model')(sequelize);
// modelos inventario
const Almacen = require('./almacen.model')(sequelize);
const CategoriaInventario = require('./categoriainventario.model')(sequelize);
const SubCategoriaInventario = require('./subcategoriainventario.model')(sequelize);
const Insumo = require('./insumo.model')(sequelize);
const Inventario = require('./inventario.model')(sequelize);
const Kardex = require('./kardex.model')(sequelize);
// tablas independientes
const Cuadrante = require('./cuadrante.model')(sequelize);
const UbicacionPersona = require('./ubicacionpersona.model')(sequelize);
const TipoDiente = require('./tipodiente.model')(sequelize);
const Diagnostico = require('./diagnostico.model')(sequelize);
const Procedimiento = require('./procedimiento.model')(sequelize);
const TipoConcentimiento = require('./tipoconcentimiento.model')(sequelize);
// tablas dependientes
const Diente = require('./diente.model')(sequelize);
const Fotos = require('./fotos.model')(sequelize);
const EnfermedadActual = require('./enfermedadactual.model')(sequelize);
const ExploracionFisica = require('./exploracionfisica.model')(sequelize);
const Cronologia = require('./cronologia.model')(sequelize);
const Receta = require('./receta.model')(sequelize);
const Evolucion = require('./evolucion.model')(sequelize);
const Concentimiento = require('./concentimiento.model')(sequelize);
const PlanTratamiento = require('./plantratamiento.model')(sequelize);
const OdontogramaClinico = require('./odontogramaclinico.model')(sequelize);
const OdontogramaEconomico = require('./odontogramaeconomico.model')(sequelize);
// tablas muy dependientes
const ItemReceta = require('./itemreceta.model')(sequelize);
const Tratamiento = require('./tratamiento.model')(sequelize);
const EstadoDiente = require('./estadodiente.model')(sequelize);
// para laboratorio
const Laboratorio = require('./laboratorio.model')(sequelize);
const EmpresaLaboratorio = require('./empresalaboratorio.model')(sequelize);
const OrdenLaboratorio = require('./ordenlaboratorio.model')(sequelize);
const ItemLaboratorio = require('./itemlaboratorio.model')(sequelize);
const SubItemLaboratorio = require('./subitemlaboratorio.model ')(sequelize);
const PeticionLaboratorio = require('./peticionlaboratorio.model')(sequelize);
const ResultadoLaboratorio = require('./resultadoboratorio.model')(sequelize);
const ItemResultadoLaboratorio = require('./itemresultadolaboratorio.model')(sequelize);
// para radiografia
const Radiografia = require('./radiografia.model')(sequelize);
const EmpresaRadiografia = require('./empresaradiografia.model')(sequelize);
const OrdenRadiografia = require('./ordenradiografia.model')(sequelize);
const ItemRadiografia = require('./itemradiografia.model')(sequelize);
const PeticionRadiografia = require('./peticionradiografia.model')(sequelize);
const ResultadoRadiografia = require('./resultadoradiografia.model')(sequelize);
const ItemResultadoRadiografia = require('./itemresultadoradiografia.model')(sequelize);
// tablas de economía
const Proveedor = require('./proveedor.model')(sequelize);
const Catalogo = require('./catalogo.model')(sequelize);
const Ingreso = require('./ingreso.model')(sequelize);
const Egreso = require('./egreso.model')(sequelize);
const Tarifario = require('./tarifario.model')(sequelize);
const Factura = require('./factura.model')(sequelize);
const ItemFactura = require('./itemfactura.model')(sequelize);
const Facturacion = require('./facturacion.model')(sequelize);
const EmisionFactura = require('./emisionfactura.model')(sequelize);
const EmisionBoleta = require('./emisionboleta.model')(sequelize);
const PresupuestoParcial = require('./presupuestoparcial.model')(sequelize);
const PresupuestoTotal = require('./presupuestototal.model')(sequelize);
// los dientes clinicos y economicos
const DienteClinico = require('./dienteclinico.model')(sequelize);
const DienteEconomico = require('./dienteeconomico.model')(sequelize);
// Definir Relaciones primera parte
// relacion empresa ➡️ sede
Empresa.hasMany(Sede);
Sede.belongsTo(Empresa);
// relacion tipodocumento ➡️ cliente
TipoDocumento.hasMany(Cliente);
Cliente.belongsTo(TipoDocumento);
// relacion sede ➡️ consultorio
Sede.hasMany(Consultorio);
Consultorio.belongsTo(Sede);
// relacion servicio ➡️ consultorio
Servicio.hasMany(Consultorio);
Consultorio.belongsTo(Servicio);
// relacion cliente ➡️ Incidencia
Cliente.hasMany(Incidencia, { foreignKey: 'ClienteId' });
Incidencia.belongsTo(Cliente, { foreignKey: 'ClienteId', as: 'cliente' });
// relacion TipoIncidencia ➡️ incidencia
TipoIncidencia.hasMany(Incidencia, { foreignKey: 'TipoIncidenciaId' });
Incidencia.belongsTo(TipoIncidencia, { foreignKey: 'TipoIncidenciaId', as: 'tipo' });
// relacion estadoincidencia ➡️ incidencia
EstadoIncidencia.hasMany(Incidencia, { foreignKey: 'EstadoId' });
Incidencia.belongsTo(EstadoIncidencia, { foreignKey: 'EstadoId', as: 'estado' });
// relacion incidencia ➡️ incidenciadetalle
Incidencia.hasMany(IncidenciaDetalle, { foreignKey: 'IncidenciaId' });
IncidenciaDetalle.belongsTo(Incidencia, { foreignKey: 'IncidenciaId', as: 'incidencia' });
// relacion incidencia ➡️ accion
Incidencia.hasMany(Accion, { foreignKey: 'HallazgoId' });
Accion.belongsTo(Incidencia, { foreignKey: 'HallazgoId', as: 'incidencia' });
// Definir relaciones segunda parte
// relacion TipoDocPDF ➡️ Documento  
TipoDocPDF.hasMany(Documento, { foreignKey: 'TipoDocPDFId' });
Documento.belongsTo(TipoDocPDF, { foreignKey: 'TipoDocPDFId', as: 'tipo' });
// relacion CategoriaPatrimonio ➡️ SubCategoriaPatrimonio
CategoriaPatrimonio.hasMany(SubCategoriaPatrimonio, { foreignKey: 'CategoriaPatrimonioId' });
SubCategoriaPatrimonio.belongsTo(CategoriaPatrimonio, { foreignKey: 'CategoriaPatrimonioId', as: 'categoria' });
// relacion SubCategoriaPatrimonio ➡️ Patrimonio
SubCategoriaPatrimonio.hasMany(Patrimonio, { foreignKey: 'SubCategoriaPatrimonioId' });
Patrimonio.belongsTo(SubCategoriaPatrimonio, { foreignKey: 'SubCategoriaPatrimonioId', as: 'subcategoria' });
// relacion Patrimonio ➡️ Movimiento
Patrimonio.hasMany(Movimiento, { foreignKey: 'PatrimonioId' });
Movimiento.belongsTo(Patrimonio, { foreignKey: 'PatrimonioId', as: 'patrimonio' });
// relacion CategoriaInventario ➡️ SubCategoriaInventario
CategoriaInventario.hasMany(SubCategoriaInventario, { foreignKey: 'CategoriaInventarioId' });
SubCategoriaInventario.belongsTo(CategoriaInventario, { foreignKey: 'CategoriaInventarioId', as: 'categoria' });
// relacion SubCategoriaInventario ➡️ Insumo
SubCategoriaInventario.hasMany(Insumo, { foreignKey: 'SubCategoriaInventarioId' });
Insumo.belongsTo(SubCategoriaInventario, { foreignKey: 'SubCategoriaInventarioId', as: 'subcategoria' });
// relacion Insumo ➡️ Inventario
Insumo.hasMany(Inventario, { foreignKey: 'InsumoId' });
Inventario.belongsTo(Insumo, { foreignKey: 'InsumoId', as: 'insumo' });
// relacion Almacen ➡️ Inventario
Almacen.hasMany(Inventario, { foreignKey: 'AlmacenId' });
Inventario.belongsTo(Almacen, { foreignKey: 'AlmacenId', as: 'almacen' });
// relacion Insumo ➡️ Kardex
Insumo.hasMany(Kardex, { foreignKey: 'InsumoId' });
Kardex.belongsTo(Insumo, { foreignKey: 'InsumoId', as: 'insumo' });
// relacion Almacen ➡️ Kardex
Almacen.hasMany(Kardex, { foreignKey: 'AlmacenId' });
Kardex.belongsTo(Almacen, { foreignKey: 'AlmacenId', as: 'almacen' });
// Definir relaciones
// relacion Cuadrante ➡️ Diente
Cuadrante.hasMany(Diente, { foreignKey: 'CuadranteId' });
Diente.belongsTo(Cuadrante, { foreignKey: 'CuadranteId', as: 'cuadrante' });
// relacion TipoDiente ➡️ Diente
TipoDiente.hasMany(Diente, { foreignKey: 'TipoDienteId' });
Diente.belongsTo(TipoDiente, { foreignKey: 'TipoDienteId', as: 'tipo' });
// relacion Ubicacion ➡️ Diente
Ubicacion.hasMany(Diente, { foreignKey: 'UbicacionId' });
Diente.belongsTo(Ubicacion, { foreignKey: 'UbicacionId', as: 'ubicacion' });
// Definir relaciones
// relacion Paciente ➡️ Familiar
Paciente.hasMany(Familiar);
Familiar.belongsTo(Paciente);
// relacion Paciente ➡️ Covertura
Paciente.hasMany(Covertura);
Covertura.belongsTo(Paciente);
// relacion Usuario ➡️ Atiende
Usuario.hasMany(Atiende);
Atiende.belongsTo(Usuario);
// relacion Paciente ➡️ UbicacionPersona
Paciente.hasMany(UbicacionPersona);
UbicacionPersona.belongsTo(Paciente);
// relacion Usuario ➡️ UbicacionPersona
Usuario.hasMany(UbicacionPersona);
UbicacionPersona.belongsTo(Usuario);
// relacion Paciente ➡️ Agendamiento
Paciente.hasMany(Agendamiento);
Agendamiento.belongsTo(Paciente);
// relacion Usuario ➡️ Agendamiento
Usuario.hasMany(Agendamiento);
Agendamiento.belongsTo(Usuario);
// relacion Usuario ➡️ Auditoria
Usuario.hasMany(Auditoria);
Auditoria.belongsTo(Usuario);
// relacion TipoConcentimiento ➡️ Concentimiento
TipoConcentimiento.hasMany(Concentimiento,  { foreignKey: 'TipoConcentimientoId' });
Concentimiento.belongsTo(TipoConcentimiento, { foreignKey: 'TipoConcentimientoId', as: 'tipo' });
// relacion Paciente ➡️ Concentimiento
Paciente.hasMany(Concentimiento);
Concentimiento.belongsTo(Paciente);
// relacion Paciente ➡️ Fotos
Paciente.hasMany(Fotos);
Fotos.belongsTo(Paciente);
// relacion Paciente ➡️ Receta
Paciente.hasMany(Receta, { foreignKey: 'PacienteId' });
Receta.belongsTo(Paciente, { foreignKey: 'PacienteId', as: 'paciente' });
// relacion Paciente ➡️ Evolucion
Paciente.hasMany(Evolucion);
Evolucion.belongsTo(Paciente);
// relacion Paciente ➡️ EnfermedadActual
Paciente.hasMany(EnfermedadActual);
EnfermedadActual.belongsTo(Paciente);
// relacion Paciente ➡️ ExploracionFisica
Paciente.hasMany(ExploracionFisica);
ExploracionFisica.belongsTo(Paciente);
// relacion Paciente ➡️ PlanTratamiento
Paciente.hasMany(PlanTratamiento);
PlanTratamiento.belongsTo(Paciente);
// relacion Paciente ➡️ Cronologia
Paciente.hasMany(Cronologia);
Cronologia.belongsTo(Paciente);
// relacion Paciente ➡️ OdontogramaClinico
Paciente.hasMany(OdontogramaClinico);
OdontogramaClinico.belongsTo(Paciente);
// relacion Paciente ➡️ OdontogramaEconomico
Paciente.hasMany(OdontogramaEconomico);
OdontogramaEconomico.belongsTo(Paciente);
// relacion Receta ➡️ ItemReceta
Receta.hasMany(ItemReceta);
ItemReceta.belongsTo(Receta);
// relacion PlanTratamiento ➡️ Tratamiento
PlanTratamiento.hasMany(Tratamiento);
Tratamiento.belongsTo(PlanTratamiento);
// relacion Diente ➡️ EstadoDiente
Hallazgo.hasMany(EstadoDiente, { foreignKey: 'HallazgoId' });
EstadoDiente.belongsTo(Hallazgo, { foreignKey: 'HallazgoId', as: 'hallazgo' });
// relacion OdontogramaClinico ➡️ DienteClinico
OdontogramaClinico.hasMany(DienteClinico, { foreignKey: 'OdontogramaClinicoId' });
DienteClinico.belongsTo(OdontogramaClinico, { foreignKey: 'OdontogramaClinicoId', as: 'odontograma' });
// relacion Cuadrante ➡️ DienteClinico
Cuadrante.hasMany(DienteClinico, { foreignKey: 'CuadranteId' });
DienteClinico.belongsTo(Cuadrante, { foreignKey: 'CuadranteId', as: 'cuadrante' });
// relacion TipoDiente ➡️ DienteClinico
TipoDiente.hasMany(DienteClinico, { foreignKey: 'TipoDienteId' });
DienteClinico.belongsTo(TipoDiente, { foreignKey: 'TipoDienteId', as: 'tipo' });
// relacion Ubicacion ➡️ DienteClinico
Ubicacion.hasMany(DienteClinico, { foreignKey: 'UbicacionId' });
DienteClinico.belongsTo(Ubicacion, { foreignKey: 'UbicacionId', as: 'ubicacion' });
// relacion OdontogramaEconomico ➡️ DienteEconomico
OdontogramaEconomico.hasMany(DienteEconomico, { foreignKey: 'OdontogramaEconomicoId' });
DienteEconomico.belongsTo(OdontogramaEconomico, { foreignKey: 'OdontogramaEconomicoId', as: 'odontograma' });
// relacion Cuadrante ➡️ DienteEconomico
Cuadrante.hasMany(DienteEconomico, { foreignKey: 'CuadranteId' });
DienteEconomico.belongsTo(Cuadrante, { foreignKey: 'CuadranteId', as: 'cuadrante' });
// relacion TipoDiente ➡️ DienteEconomico
TipoDiente.hasMany(DienteEconomico, { foreignKey: 'TipoDienteId' });
DienteEconomico.belongsTo(TipoDiente, { foreignKey: 'TipoDienteId', as: 'tipo' });
// relacion Ubicacion ➡️ DienteEconomico
Ubicacion.hasMany(DienteEconomico, { foreignKey: 'UbicacionId' });
DienteEconomico.belongsTo(Ubicacion, { foreignKey: 'UbicacionId', as: 'ubicacion' });
// Definir relaciones para laboratorio
// relacion Laboratorio ➡️ ItemLaboratorio
Laboratorio.hasMany(ItemLaboratorio, { foreignKey: 'LaboratorioId' });
ItemLaboratorio.belongsTo(Laboratorio, { foreignKey: 'LaboratorioId', as: 'laboratorio' });
// relacion ItemLaboratorio ➡️ SubItemLaboratorio
ItemLaboratorio.hasMany(SubItemLaboratorio, { foreignKey: 'ItemLaboratorioId' });
SubItemLaboratorio.belongsTo(ItemLaboratorio, { foreignKey: 'ItemLaboratorioId', as: 'item' });
// relacion OrdenLaboratorio ➡️ PeticionLaboratorio
OrdenLaboratorio.hasMany(PeticionLaboratorio, { foreignKey: 'OrdenLaboratorioId' });
PeticionLaboratorio.belongsTo(OrdenLaboratorio, { foreignKey: 'OrdenLaboratorioId', as: 'orden' });
// relacion ItemLaboratorio ➡️ PeticionLaboratorio
ItemLaboratorio.hasMany(PeticionLaboratorio, { foreignKey: 'ItemLaboratorioId' });
PeticionLaboratorio.belongsTo(ItemLaboratorio, { foreignKey: 'ItemLaboratorioId', as: 'item' });
// relacion EmpresaLaboratorio ➡️ ResultadoLaboratorio
EmpresaLaboratorio.hasMany(ResultadoLaboratorio, { foreignKey: 'EmpresaLaboratorioId' });
ResultadoLaboratorio.belongsTo(EmpresaLaboratorio, { foreignKey: 'EmpresaLaboratorioId', as: 'empresa' });
// relacion OrdenLaboratorio ➡️ ResultadoLaboratorio
OrdenLaboratorio.hasMany(ResultadoLaboratorio, { foreignKey: 'OrdenLaboratorioId' });
ResultadoLaboratorio.belongsTo(OrdenLaboratorio, { foreignKey: 'OrdenLaboratorioId', as: 'orden' });
// relacion ResultadoLaboratorio ➡️ ItemResultadoLaboratorio
ResultadoLaboratorio.hasMany(ItemResultadoLaboratorio, { foreignKey: 'ResultadoLaboratorioId' });
ItemResultadoLaboratorio.belongsTo(ResultadoLaboratorio, { foreignKey: 'ResultadoLaboratorioId', as: 'resultado' });
// relacion PeticionLaboratorio ➡️ ItemResultadoLaboratorio
PeticionLaboratorio.hasMany(ItemResultadoLaboratorio, { foreignKey: 'PeticionLaboratorioId' });
ItemResultadoLaboratorio.belongsTo(PeticionLaboratorio, { foreignKey: 'PeticionLaboratorioId', as: 'peticion' });
// relacion SubItemLaboratorio ➡️ ItemResultadoLaboratorio
SubItemLaboratorio.hasMany(ItemResultadoLaboratorio, { foreignKey: 'SubItemLaboratorioId' });
ItemResultadoLaboratorio.belongsTo(SubItemLaboratorio, { foreignKey: 'SubItemLaboratorioId', as: 'subitem' });
// Definir relaciones para radiografia
// relacion Radiografia ➡️ ItemRadiografia
Radiografia.hasMany(ItemRadiografia, { foreignKey: 'RadiografiaId' });
ItemRadiografia.belongsTo(Radiografia, { foreignKey: 'RadiografiaId', as: 'radiografia' });
// relacion EmpresaRadiografia ➡️ ResultadoRadiografia
EmpresaRadiografia.hasMany(ResultadoRadiografia, { foreignKey: 'EmpresaRadiografiaId' });
ResultadoRadiografia.belongsTo(EmpresaRadiografia, { foreignKey: 'EmpresaRadiografiaId', as: 'empresa' });
// relacion OrdenRadiografia ➡️ ResultadoRadiografia
OrdenRadiografia.hasMany(ResultadoRadiografia, { foreignKey: 'OrdenRadiografiaId' });
ResultadoRadiografia.belongsTo(OrdenRadiografia, { foreignKey: 'OrdenRadiografiaId', as: 'orden' });
// relacion OrdenRadiografia ➡️ PeticionRadiografia
OrdenRadiografia.hasMany(PeticionRadiografia, { foreignKey: 'OrdenRadiografiaId' });
PeticionRadiografia.belongsTo(OrdenRadiografia, { foreignKey: 'OrdenRadiografiaId', as: 'orden' });
// relacion ItemRadiografia ➡️ PeticionRadiografia
ItemRadiografia.hasMany(PeticionRadiografia, { foreignKey: 'ItemRadiografiaId' });
PeticionRadiografia.belongsTo(ItemRadiografia, { foreignKey: 'ItemRadiografiaId', as: 'item' });
// relacion ResultadoRadiografia ➡️ ItemResultadoRadiografia
ResultadoRadiografia.hasMany(ItemResultadoRadiografia, { foreignKey: 'ResultadoRadiografiaId' });
ItemResultadoRadiografia.belongsTo(ResultadoRadiografia, { foreignKey: 'ResultadoRadiografiaId', as: 'resultado' });
// relacion PeticionRadiografia ➡️ ItemResultadoRadiografia
PeticionRadiografia.hasMany(ItemResultadoRadiografia, { foreignKey: 'PeticionRadiografiaId' });
ItemResultadoRadiografia.belongsTo(PeticionRadiografia, { foreignKey: 'PeticionRadiografiaId', as: 'peticion' });
// Definir relaciones
// relacion Categoria ➡️ Catalogo
Sede.hasMany(Proveedor, { foreignKey: 'SedeId' });
Proveedor.belongsTo(Sede, { foreignKey: 'SedeId', as: 'sede' });
// relacion Categoria ➡️ Catalogo
Categoria.hasMany(Catalogo, { foreignKey: 'CategoriaId' });
Catalogo.belongsTo(Categoria, { foreignKey: 'CategoriaId', as: 'categoria' });
// relacion Hallazgo ➡️ Catalogo
Hallazgo.hasMany(Catalogo, { foreignKey: 'HallazgoId' });
Catalogo.belongsTo(Hallazgo, { foreignKey: 'HallazgoId', as: 'hallazgo' });
// relacion Catalogo ➡️ Tarifario
Catalogo.hasMany(Tarifario, { foreignKey: 'CatalogoId' });
Tarifario.belongsTo(Catalogo, { foreignKey: 'CatalogoId', as: 'catalogo' });
// relacion Factura ➡️ OdontogramaEconomico
Factura.hasMany(OdontogramaEconomico, { foreignKey: 'FacturaId' });
OdontogramaEconomico.belongsTo(Factura, { foreignKey: 'FacturaId', as: 'factura' });
// relacion Ingreso ➡️ PresupuestoParcial
Ingreso.hasMany(PresupuestoParcial, { foreignKey: 'IngresoId' });
PresupuestoParcial.belongsTo(Ingreso, { foreignKey: 'IngresoId', as: 'ingreso' });
// relacion Ingreso ➡️ PresupuestoTotal
Ingreso.hasMany(PresupuestoTotal, { foreignKey: 'IngresoId' });
PresupuestoTotal.belongsTo(Ingreso, { foreignKey: 'IngresoId', as: 'ingreso' });
// relacion Tarifario ➡️ ItemFactura
Tarifario.hasMany(ItemFactura, { foreignKey: 'TarifarioId' });
ItemFactura.belongsTo(Tarifario, { foreignKey: 'TarifarioId', as: 'tarifario' });
// relacion Factura ➡️ ItemFactura
Factura.hasMany(ItemFactura, { foreignKey: 'FacturaId' });
ItemFactura.belongsTo(Factura, { foreignKey: 'FacturaId', as: 'factura' });
// relacion Factura ➡️ Facturacion
Factura.hasMany(Facturacion, { foreignKey: 'FacturaId' });
Facturacion.belongsTo(Factura, { foreignKey: 'FacturaId', as: 'factura' });
// relacion Factura ➡️ EmisionFactura
Factura.hasMany(EmisionFactura, { foreignKey: 'FacturaId' });
EmisionFactura.belongsTo(Factura, { foreignKey: 'FacturaId', as: 'factura' });
// relacion Factura ➡️ EmisionBoleta
Factura.hasMany(EmisionBoleta, { foreignKey: 'FacturaId' });
EmisionBoleta.belongsTo(Factura, { foreignKey: 'FacturaId', as: 'factura' });

// Exportar modelos y conexión
module.exports = { sequelize, 
  EstadoAgendamiento, EstadoIncidencia, EstadoPago,  EstadoCampania, Periodo, Genero, 
  EstadoOrdenLaboratorio, TipoActividad, TipoCampania, TipoRespuesta, TipoIngreso,
  EstadoUsuario, FuenteCaptacion, GradoInstruccion, TipoProveedor, TipoPago, Relacion,
  Vinculacion, TipoAfiliacion, TipoDocumento, TipoIncidencia, TipoUsuario, CargoUsuario, 
  Iafa, Servicio, Profesion, Empresa, Sede, Consultorio, 
  Cliente, Incidencia, IncidenciaDetalle, Accion,
  EncuestaSimple, EncuestaKids, EncuestaCompleja,
  Categoria, Hallazgo, 
  // tablas de agendamiento
  Usuario, Paciente, UbicacionPersona, Agendamiento, 
  Familiar, Covertura, Atiende, Auditoria,
  // RRHH
  Evaluacion, HistorialLaboral, Pago, TipoDocPDF, Documento,
  // Patrimonio
  CategoriaPatrimonio, SubCategoriaPatrimonio, Patrimonio, Movimiento,
  // Inventario
  Almacen, CategoriaInventario, SubCategoriaInventario,
  Insumo, Inventario, Kardex,
  // para laboratorio
  Laboratorio, EmpresaLaboratorio, OrdenLaboratorio, 
  ItemLaboratorio, SubItemLaboratorio, PeticionLaboratorio, 
  ResultadoLaboratorio, ItemResultadoLaboratorio,
  // para radiografia
  Radiografia, EmpresaRadiografia, OrdenRadiografia, 
  ItemRadiografia, ResultadoRadiografia, PeticionRadiografia, 
  ItemResultadoRadiografia,
  // tablas independientes
  TipoDiente, Cuadrante, Ubicacion, TipoConcentimiento, Diagnostico, Procedimiento,
  // tablas dependientes
  Diente, Fotos, Receta, Evolucion, Concentimiento, 
  EnfermedadActual, ExploracionFisica, PlanTratamiento, Cronologia,
  // tablas de economía
  Proveedor, Catalogo, Ingreso, Egreso, 
  Tarifario, PresupuestoParcial, PresupuestoTotal,
  Factura, ItemFactura, Facturacion, EmisionFactura, EmisionBoleta,
  // tablas muy dependientes
  OdontogramaClinico, OdontogramaEconomico, 
  ItemReceta, Tratamiento, EstadoDiente,
  DienteClinico, DienteEconomico,
};
