const {
    DataTypes
} = require('sequelize');

module.exports = (sequelize) => {
    return sequelize.define('Ingreso', {
        id: {
            type: DataTypes.INTEGER,
            primaryKey: true,
            autoIncrement: true
        },
        FechaRegistro: {
            type: DataTypes.DATE,
            allowNull: false
        },
        // personal que registro el pago
        Personal: {
            type: DataTypes.STRING,
            allowNull: false
        },
        // si es una atencion, nombre completo del personal que atendio
        Odontologo: {
            type: DataTypes.STRING,
            allowNull: false
        },
        // nombre completo de quien realiza el pago
        DatoProveedor: {
            type: DataTypes.STRING,
            allowNull: false
        },
        // nro documento del proveedor
        DocProveedor: {
            type: DataTypes.STRING,
            allowNull: false
        },
        // detalles del pago
        Detalles: {
            type: DataTypes.STRING,
            allowNull: false
        },
        // motivo del pago
        MotivoIngreso: {
            type: DataTypes.STRING,
            allowNull: false
        },
        // se repite el monto pagado
        MontoSoles: {
            type: DataTypes.DECIMAL(10, 2),
            allowNull: false
        },
        // sede a la que pertenece el ingreso
        SedeId: {
            type: DataTypes.INTEGER,
            allowNull: false
        },
        // factura, boleta, ninguno, aseguradora
        TipoIngresoId: {
            type: DataTypes.INTEGER,
            allowNull: false
        },
        // Efectivo, Tarjeta, Transferencia, Deposito, Yape, Plin
        TipoPagoId: {
            type: DataTypes.INTEGER,
            allowNull: false
        },
        // quien registra el ingreso
        UsuarioId: {
            type: DataTypes.INTEGER,
            allowNull: false
        },
        // paciente, alquiler aseguradora, etc
        TipoProveedorId: {
            type: DataTypes.INTEGER,
            allowNull: false
        }
    });
};