const {
    DataTypes
} = require('sequelize');

module.exports = (sequelize) => {
    return sequelize.define('Inventario', {
        id: {
            type: DataTypes.INTEGER,
            autoIncrement: true,
            primaryKey: true
        },
        Cantidad: {
            type: DataTypes.DECIMAL(10, 2),
            allowNull: false
        },
        Estado: {
            type: DataTypes.STRING,
            allowNull: false
        },
        AlmacenId: {
            type: DataTypes.INTEGER,
            references: {
                model: 'Almacens',
                key: 'id'
            }
        },
        InsumoId: {
            type: DataTypes.INTEGER,
            references: {
                model: 'Insumos',
                key: 'id'
            }
        },
    });
};