const {
    DataTypes
} = require('sequelize');

module.exports = (sequelize) => {
    return sequelize.define('ItemFactura', {
        id: {
            type: DataTypes.INTEGER,
            primaryKey: true,
            autoIncrement: true
        },
        Cantidad: {
            type: DataTypes.INTEGER,
            allowNull: false
        },
        Nombre: {
            type: DataTypes.STRING,
            allowNull: false
        },
        Piezas: {
            type: DataTypes.STRING,
            allowNull: false
        },
        Precio: {
            type: DataTypes.INTEGER,
            allowNull: false
        },
        Subtotal: {
            type: DataTypes.DECIMAL(10, 2),
            allowNull: false
        },
        FacturaId: {
            type: DataTypes.INTEGER,
            references: {
                model: 'Facturas',
                key: 'id'
            }
        },
        TarifarioId: {
            type: DataTypes.INTEGER,
            references: {
                model: 'Tarifarios',
                key: 'id'
            }
        }
    });
}