const {
    DataTypes
} = require('sequelize');

module.exports = (sequelize) => {
    return sequelize.define('Kardex', {
        id: {
            type: DataTypes.INTEGER,
            autoIncrement: true,
            primaryKey: true
        },
        Entrada: {
            type: DataTypes.DECIMAL(10, 3),
            allowNull: false
        },
        Salida: {
            type: DataTypes.DECIMAL(10, 3),
            allowNull: false
        },
        InsumoId: {
            type: DataTypes.INTEGER,
            references: {
                model: 'Insumos',
                key: 'id'
            }
        },
        AlmacenId: {
            type: DataTypes.INTEGER,
            references: {
                model: 'Almacens',
                key: 'id'
            }
        },
    });
};