const {
    DataTypes
} = require('sequelize');

module.exports = (sequelize) => {
    return sequelize.define('Movimiento', {
        id: {
            type: DataTypes.INTEGER,
            autoIncrement: true,
            primaryKey: true
        },
        FechaMovimiento: {
            type: DataTypes.DATE,
            allowNull: false
        },
        TipoMovimiento: {
            type: DataTypes.STRING,
            allowNull: false
        },
        MotivoMovimiento: {
            type: DataTypes.STRING,
            allowNull: false
        },
        UbicacionInicial: {
            type: DataTypes.STRING,
            allowNull: false
        },
        UbicacionFinal: {
            type: DataTypes.STRING,
            allowNull: false
        },
        EstadoInicial: {
            type: DataTypes.STRING,
            allowNull: false
        },
        EstadoFinal: {
            type: DataTypes.STRING,
            allowNull: false
        },
        ValorPatrimonio: {
            type: DataTypes.STRING,
            allowNull: false
        },
        ResponsablePatrimonioAntes: {
            type: DataTypes.STRING,
            allowNull: false
        },
        ResponsablePatrimonioDespues: {
            type: DataTypes.STRING,
            allowNull: false
        },
        Observacion: {
            type: DataTypes.STRING,
            allowNull: false
        },
        SedeId: {
            type: DataTypes.INTEGER,
            allowNull: false
        },
        PatrimonioId: {
            type: DataTypes.INTEGER,
            references: {
                model: 'Patrimonios',
                key: 'id'
            }
        },
    });
};