const {
    DataTypes
} = require('sequelize');

module.exports = (sequelize) => {
    return sequelize.define(
        'OdontogramaEconomico',
        {
            id: {
                type: DataTypes.INTEGER,
                primaryKey: true,
                autoIncrement: true
            },
            FechaCreacion: {
                type: DataTypes.DATE,
                allowNull: false
            },
            Especificaciones: {
                type: DataTypes.STRING,
                allowNull: false
            },
            Observaciones: {
                type: DataTypes.STRING,
                allowNull: false
            },
            ImagenOdontograma: {
                type: DataTypes.STRING,
                allowNull: false
            },
            FacturaId: {
                type: DataTypes.INTEGER,
                allowNull: false
            },
            PacienteId: {
                type: DataTypes.INTEGER,
                references: {
                    model: 'Pacientes',
                    key: 'id'
                }
            }
        }
    );
}