const {
    DataTypes
} = require('sequelize');

module.exports = (sequelize) => {
    return sequelize.define('Paciente', {
        id: {
            type: DataTypes.INTEGER,
            primaryKey: true,
            autoIncrement: true
        },
        Nombres: {
            type: DataTypes.STRING,
            allowNull: false
        },
        Apellidos: {
            type: DataTypes.STRING,
            allowNull: false
        },
        Correo: {
            type: DataTypes.STRING,
            allowNull: false
        },
        Celular: {
            type: DataTypes.STRING,
            allowNull: false
        },
        Documento: {
            type: DataTypes.STRING,
            allowNull: false,
            unique: true
        },
        NroHistoriaClinica: {
            type: DataTypes.STRING,
            allowNull: false,
            unique: true
        },
        FechaNacimiento: {
            type: DataTypes.DATE,
            allowNull: false
        },
        Ocupacion: {
            type: DataTypes.STRING,
            allowNull: false
        },
        Observacion: {
            type: DataTypes.TEXT
        },
        Foto: {
            type: DataTypes.STRING
        },
        TipoAfiliacion: {
            type: DataTypes.STRING,
            allowNull: false
        },
        AntecedentesFamiliares: {
            type: DataTypes.STRING,
            allowNull: false,
            defaultValue: ''
        },
        AntecedentesPersonales: {
            type: DataTypes.STRING,
            allowNull: false,
            defaultValue: ''
        },
        FechaAfiliacion: {
            type: DataTypes.DATE,
            allowNull: false
        },
        IAFAId: {
            type: DataTypes.INTEGER,
            allowNull: false
        },
        TipoDocumentoId: {
            type: DataTypes.INTEGER,
            allowNull: false
        },
        GeneroId: {
            type: DataTypes.INTEGER,
            allowNull: false
        },
        GradoInstruccionId: {
            type: DataTypes.INTEGER,
            allowNull: false
        },
        SedeId: {
            type: DataTypes.INTEGER,
            allowNull: false
        },
        FuenteCaptacionId: {
            type: DataTypes.INTEGER,
            allowNull: false
        },
        OdontologoId: {
            type: DataTypes.INTEGER,
            allowNull: false,
        },
        
    });
};