const {
    DataTypes
} = require('sequelize');

module.exports = (sequelize) => {
    return sequelize.define('Patrimonio', {
        id: {
            type: DataTypes.INTEGER,
            autoIncrement: true,
            primaryKey: true
        },
        Codigo: {
            type: DataTypes.STRING,
            allowNull: false,
            unique: true
        },
        Nombre: {
            type: DataTypes.STRING,
            allowNull: false
        },
        Descripcion: {
            type: DataTypes.STRING,
            allowNull: false
        },
        Ubicacion: {
            type: DataTypes.STRING,
            allowNull: false
        },
        FechaAdquisicion: {
            type: DataTypes.STRING,
            allowNull: false
        },
        FechaEliminacion: {
            type: DataTypes.STRING,
            allowNull: false
        },
        Estado: {
            type: DataTypes.STRING,
            allowNull: false
        },
        Valor: {
            type: DataTypes.STRING,
            allowNull: false
        },
        Responsable: {
            type: DataTypes.STRING,
            allowNull: false
        },
        SedeId: {
            type: DataTypes.INTEGER,
            allowNull: false
        },
        SubCategoriaPatrimonioId: {
            type: DataTypes.INTEGER,
            references: {
                model: 'SubCategoriaPatrimonios',
                key: 'id'
            }
        },
    });
};