const {
    DataTypes
} = require('sequelize');

module.exports = (sequelize) => {
    return sequelize.define('PeticionRadiografia', {
        id: {
            type: DataTypes.INTEGER,
            primaryKey: true,
            autoIncrement: true
        },
        Nombre: {
            type: DataTypes.STRING,
            allowNull: false
        },
        Extras: {
            type: DataTypes.STRING,
            allowNull: false
        },
        ObservacionEspecifica: {
            type: DataTypes.STRING,
            allowNull: false
        },
        OrdenRadiografiaId: {
            type: DataTypes.INTEGER,
            references: {
                model: 'OrdenRadiografia',
                key: 'id'
            }
        },
        ItemRadiografiaId: {
            type: DataTypes.INTEGER,
            references: {
                model: 'ItemRadiografia',
                key: 'id'
            }
        }
    });
};