const {
    DataTypes
} = require('sequelize');

module.exports = (sequelize) => {
    return sequelize.define('PresupuestoTotal', {
        id: {
            type: DataTypes.INTEGER,
            primaryKey: true,
            autoIncrement: true
        },
        ACuenta: {
            type: DataTypes.DECIMAL(10, 2),
            allowNull: false
        },
        Saldo: {
            type: DataTypes.DECIMAL(10, 2),
            allowNull: false
        },
        EF: {
            type: DataTypes.STRING,
            allowNull: false
        },
        TC: {
            type: DataTypes.STRING,
            allowNull: false
        },
        Fecha: {
            type: DataTypes.DATE,
            allowNull: false
        },
        PacienteId: {
            type: DataTypes.INTEGER,
            allowNull: false
        },
        IngresoId: {
            type: DataTypes.INTEGER,
            references: {
                model: 'Ingresos',
                key: 'id'
            }
        }
    });
}