const {
    DataTypes
} = require('sequelize');

module.exports = (sequelize) => {
    return sequelize.define('ResultadoLaboratorio', {
        id: {
            type: DataTypes.INTEGER,
            primaryKey: true,
            autoIncrement: true
        },
        FechaResultado: {
            type: DataTypes.DATE,
            allowNull: false
        },
        RutaInforme: {
            type: DataTypes.STRING,
            allowNull: false
        },
        Observaciones: {
            type: DataTypes.STRING,
            allowNull: false
        },
        OrdenLaboratorioId: {
            type: DataTypes.INTEGER,
            references: {
                model: 'OrdenLaboratorios',
                key: 'id'
            }
        },
        EmpresaLaboratorioId: {
            type: DataTypes.INTEGER,
            references: {
                model: 'EmpresaLaboratorios',
                key: 'id'
            }
        }
    });
};