const {
    DataTypes
} = require('sequelize');

module.exports = (sequelize) => {
    return sequelize.define('ResultadoRadiografia', {
        id: {
            type: DataTypes.INTEGER,
            primaryKey: true,
            autoIncrement: true
        },
        FechaResultado: {
            type: DataTypes.DATE,
            allowNull: false
        },
        RutaInforme: {
            type: DataTypes.STRING,
            allowNull: false
        },
        Observaciones: {
            type: DataTypes.STRING,
            allowNull: false
        },
        OrdenRadiografiaId: {
            type: DataTypes.INTEGER,
            references: {
                model: 'OrdenRadiografia',
                key: 'id'
            }
        },
        EmpresaRadiografiaId: {
            type: DataTypes.INTEGER,
            references: {
                model: 'EmpresaRadiografia',
                key: 'id'
            }
        }
    });
};