const {
    DataTypes
} = require('sequelize');

module.exports = (sequelize) => {
    return sequelize.define('Tarifario', {
        id: {
            type: DataTypes.INTEGER,
            primaryKey: true,
            autoIncrement: true
        },
        Categoria: {
            type: DataTypes.STRING,
            allowNull: false
        },
        // nombre que viene del catalogo de la IAFA
        Nombre: {
            type: DataTypes.STRING,
            allowNull: false
        },
        Afecta: {
            type: DataTypes.STRING,
            allowNull: false
        },
        // Modo de procedimiento
        // Puede ser "Individual" o "Grupal" 0 Ninguno
        Modo: {
            type: DataTypes.STRING,
            allowNull: false
        },
        PrecioMinimo: {
            type: DataTypes.DECIMAL(10, 2),
            allowNull: false
        },
        Precio: {
            type: DataTypes.DECIMAL(10, 2),
            allowNull: false
        },
        // nombre de la IAFA a la que pertenece el tarifario
        NombreIAFA: {
            type: DataTypes.STRING,
            allowNull: false
        },
        // ruc de la iafa para su filtrado
        RUCIAFA: {
            type: DataTypes.STRING,
            allowNull: false
        },
        IAFAId: {
            type: DataTypes.INTEGER,
            allowNull: false
        },
        // tramamiento o precedimiento
        CatalogoId: {
            type: DataTypes.INTEGER,
            references: {
                model: 'Catalogos',
                key: 'id'
            }
        }
    });
};