const {
    DataTypes
} = require('sequelize');

module.exports = (sequelize) => {
    return sequelize.define('Usuario', {
        id: {
            type: DataTypes.INTEGER,
            primaryKey: true,
            autoIncrement: true
        },
        Nombre: {
            type: DataTypes.STRING,
            allowNull: false
        },
        Apellido: {
            type: DataTypes.STRING,
            allowNull: false
        },
        Correo: {
            type: DataTypes.STRING,
            allowNull: false,
            unique: true
        },
        Celular: {
            type: DataTypes.STRING,
            allowNull: false,
            unique: true
        },
        TipoDocumentoId: {
            type: DataTypes.INTEGER,
            allowNull: false
        },
        Documento: {
            type: DataTypes.STRING,
            allowNull: false,
            unique: true
        },
        Colegiatura: {
            type: DataTypes.STRING,
            allowNull: false
        },
        CodigoEspecialista: {
            type: DataTypes.STRING,
            allowNull: false
        },
        FechaNacimiento: {
            type: DataTypes.DATE,
            allowNull: false
        },
        GeneroId: {
            type: DataTypes.INTEGER,
            allowNull: false
        },
        Contrasenia: {
            type: DataTypes.STRING,
            allowNull: false
        },
        TipoUsuarioId: {
            type: DataTypes.INTEGER,
            allowNull: false
        },
        EstadoId: {
            type: DataTypes.INTEGER,
            allowNull: false
        },
        VinculacionId: {
            type: DataTypes.INTEGER,
            allowNull: false
        },
        SedeId: {
            type: DataTypes.INTEGER,
            allowNull: false
        },
        Foto: {
            type: DataTypes.STRING
        },
        Codigo: {
            type: DataTypes.STRING,
            allowNull: true
        },
    });
};