const express = require("express");
const CategoriaController = require("../controllers/categoria.controller");

const router = express.Router();

router.get("/", CategoriaController.getCategoriaAll);
router.get("/:id", CategoriaController.getCategoriaById);
router.post("/create", CategoriaController.createCategoria);
router.put("/update/:id", CategoriaController.updateCategoria);
router.delete("/:id", CategoriaController.deleteCategoria);

module.exports = router;