const express = require("express");
const categoriainventarioController = require("../controllers/categoriainventario.controller");

const router = express.Router();
/**
 * @swagger
 * components:
 *   schemas:
 *     CategoriaInventario:
 *       type: object
 *       required:
 *         - Nombre
 *         - Descripcion
 *       properties:
 *         id:
 *           type: number
 *           description: El identificador único de la Categoria Inventario
 *         Nombre:
 *           type: string
 *           description: Nombre de la Categoria Inventario
 *         Descripcion:
 *           type: string
 *           description: Descripcion de la Categoria Inventario
 *       example:
 *         id: "1"
 *         Nombre: "Instrumental Odontológico"
 *         Descripcion: "Instrumentos manuales que se utilizan en los procedimientos"
 */
/**
 * @swagger
 * tags:
 *   name: CategoriaInventario
 *   description: API para gestionar CategoriaInventarios
 */
/**
 * @swagger
 * /inventario/categoria:
 *   get:
 *     summary: Obtiene la lista de CategoriaInventarios
 *     tags: [CategoriaInventario]
 *     responses:
 *       200:
 *         description: Lista de CategoriaInventarios.
 *         content:
 *           application/json:
 *             schema:
 *               type: array
 *               items:
 *                 $ref: '#/components/schemas/CategoriaInventario'
 */
router.get("/", categoriainventarioController.getCategoriaInventarioAll);
/**
 * @swagger
 * /inventario/categoria/{id}:
 *   get:
 *     summary: Obtiene un CategoriaInventario por ID
 *     tags: [CategoriaInventario]
 *     parameters:
 *       - in: path
 *         name: id
 *         schema:
 *           type: number
 *         required: true
 *         description: ID del CategoriaInventario
 *     responses:
 *       200:
 *         description: CategoriaInventario encontrado.
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/CategoriaInventario'
 *       404:
 *         description: CategoriaInventario no encontrado.
 */
router.get("/:id", categoriainventarioController.getCategoriaInventarioById);
/**
 * @swagger
 * /inventario/categoria/create:
 *   post:
 *     summary: Crea un nuevo CategoriaInventario
 *     tags: [CategoriaInventario]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           schema:
 *             $ref: '#/components/schemas/CategoriaInventario'
 *     responses:
 *       201:
 *         description: CategoriaInventario creado exitosamente.
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/CategoriaInventario'
 */
router.post("/create", categoriainventarioController.createCategoriaInventario);
/**
 * @swagger
 * /inventario/categoria/update/{id}:
 *   put:
 *     summary: Actualiza un CategoriaInventario existente
 *     tags: [CategoriaInventario]
 *     parameters:
 *       - in: path
 *         name: id
 *         schema:
 *           type: number
 *         required: true
 *         description: ID del CategoriaInventario a actualizar
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           schema:
 *             $ref: '#/components/schemas/CategoriaInventario'
 *     responses:
 *       200:
 *         description: CategoriaInventario actualizado exitosamente.
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/CategoriaInventario'
 *       404:
 *         description: CategoriaInventario no encontrado.
 */
router.put("/update/:id", categoriainventarioController.updateCategoriaInventario);
/**
 * @swagger
 * /inventario/categoria/{id}:
 *   delete:
 *     summary: Elimina un CategoriaInventario por ID
 *     tags: [CategoriaInventario]
 *     parameters:
 *       - in: path
 *         name: id
 *         schema:
 *           type: number
 *         required: true
 *         description: ID del CategoriaInventario a eliminar
 *     responses:
 *       200:
 *         description: CategoriaInventario eliminado exitosamente.
 *       404:
 *         description: CategoriaInventario no encontrado.
 */
router.delete("/:id", categoriainventarioController.deleteCategoriaInventario);

// Rutas de filtrado individual


module.exports = router;
