const express = require("express");
const categoriapatrimonioController = require("../controllers/categoriapatrimonio.controller");

const router = express.Router();
/**
 * @swagger
 * components:
 *   schemas:
 *     CategoriaPatrimonio:
 *       type: object
 *       required:
 *         - Nombre
 *         - Descripcion
 *       properties:
 *         id:
 *           type: number
 *           description: El identificador único de la Categoria Patrimonio
 *         Nombre:
 *           type: string
 *           description: Nombre de la Categoria Patrimonio
 *         Descripcion:
 *           type: string
 *           description: Descripcion de la Categoria Patrimonio
 *       example:
 *         id: "1"
 *         Nombre: "Equipos de Computo"
 *         Descripcion: "Equipos de Computo (Computadoras, Laptops, Impresoras, etc)"
 */
/**
 * @swagger
 * tags:
 *   name: CategoriaPatrimonio
 *   description: API para gestionar CategoriaPatrimonios
 */
/**
 * @swagger
 * /patrimonio/categoria:
 *   get:
 *     summary: Obtiene la lista de CategoriaPatrimonios
 *     tags: [CategoriaPatrimonio]
 *     responses:
 *       200:
 *         description: Lista de CategoriaPatrimonios.
 *         content:
 *           application/json:
 *             schema:
 *               type: array
 *               items:
 *                 $ref: '#/components/schemas/CategoriaPatrimonio'
 */
router.get("/", categoriapatrimonioController.getCategoriaPatrimonioAll);
/**
 * @swagger
 * /patrimonio/categoria/{id}:
 *   get:
 *     summary: Obtiene un CategoriaPatrimonio por ID
 *     tags: [CategoriaPatrimonio]
 *     parameters:
 *       - in: path
 *         name: id
 *         schema:
 *           type: number
 *         required: true
 *         description: ID del CategoriaPatrimonio
 *     responses:
 *       200:
 *         description: CategoriaPatrimonio encontrado.
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/CategoriaPatrimonio'
 *       404:
 *         description: CategoriaPatrimonio no encontrado.
 */
router.get("/:id", categoriapatrimonioController.getCategoriaPatrimonioById);
/**
 * @swagger
 * /patrimonio/categoria/create:
 *   post:
 *     summary: Crea un nuevo CategoriaPatrimonio
 *     tags: [CategoriaPatrimonio]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           schema:
 *             $ref: '#/components/schemas/CategoriaPatrimonio'
 *     responses:
 *       201:
 *         description: CategoriaPatrimonio creado exitosamente.
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/CategoriaPatrimonio'
 */
router.post("/create", categoriapatrimonioController.createCategoriaPatrimonio);
/**
 * @swagger
 * /patrimonio/categoria/update/{id}:
 *   put:
 *     summary: Actualiza un CategoriaPatrimonio existente
 *     tags: [CategoriaPatrimonio]
 *     parameters:
 *       - in: path
 *         name: id
 *         schema:
 *           type: number
 *         required: true
 *         description: ID del CategoriaPatrimonio a actualizar
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           schema:
 *             $ref: '#/components/schemas/CategoriaPatrimonio'
 *     responses:
 *       200:
 *         description: CategoriaPatrimonio actualizado exitosamente.
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/CategoriaPatrimonio'
 *       404:
 *         description: CategoriaPatrimonio no encontrado.
 */
router.put("/update/:id", categoriapatrimonioController.updateCategoriaPatrimonio);
/**
 * @swagger
 * /patrimonio/categoria/{id}:
 *   delete:
 *     summary: Elimina un CategoriaPatrimonio por ID
 *     tags: [CategoriaPatrimonio]
 *     parameters:
 *       - in: path
 *         name: id
 *         schema:
 *           type: number
 *         required: true
 *         description: ID del CategoriaPatrimonio a eliminar
 *     responses:
 *       200:
 *         description: CategoriaPatrimonio eliminado exitosamente.
 *       404:
 *         description: CategoriaPatrimonio no encontrado.
 */
router.delete("/:id", categoriapatrimonioController.deleteCategoriaPatrimonio);

// Rutas de filtrado individual


module.exports = router;
