const express = require('express');
const router = express.Router();
const importController = require('../controllers/import.controller');
// const importlabradController = require('../controllers/importhclabrad.controller');
const importecoageController = require('../controllers/importecoage.controller');
const exportController = require('../controllers/export.controller');
// const exportlabradController = require('../controllers/exporthclabrad.controller');
const exportecoageController = require('../controllers/exportecoage.controller');
const insertController = require('../controllers/insert.controller');
const updateindexController = require('../controllers/updateindex.controller');

// Ruta para exportar datos (GET: /data/export)
// exportar datos globales
router.get('/export-data', exportController.exportData);

// exportar datos de la empresa
router.get('/export-empresa', exportController.exportDataEmpresa);

// exportar datos de las incidencias
router.get('/export-incidencia', exportController.exportDataIncidencia);

// exportar datos de las encuestas
router.get('/export-encuesta', exportController.exportDataEncuesta);

// Ruta para exportar datos de paciente
router.get('/exportpaciente', exportecoageController.exportDataPaciente);

// Ruta para exportar datos de usuario
router.get('/exportusuario', exportecoageController.exportDataUsuario);

// Ruta para exportar datos de agendamiento
router.get('/exportagendamiento', exportecoageController.exportDataAgendamiento);

// Ruta para exportar datos de agendamiento
router.get('/exportauditoria', exportecoageController.exportDataAuditoria);

// Ruta para exportar datos de economia1
router.get('/expoeconomia1', exportecoageController.exportDataEconomia1);

// Ruta para exportar datos de economia2
router.get('/expoeconomia2', exportecoageController.exportDataEconomia2);

// Ruta para importar datos (POST: /data/import)
// importar datos globales
router.post('/import-data', importController.importData);

// importar datos de la empresa
router.post('/import-empresa', importController.importDataEmpresa);

// importar datos de las incidencias
router.post('/import-incidencia', importController.importDataIncidencia);

// importar datos de las encuestas
router.post('/import-encuesta', importController.importDataEncuesta);

// Ruta para importar datos paciente
router.post('/importpaciente', importecoageController.importDataPaciente);

// Ruta para importar datos usuario
router.post('/importusuario', importecoageController.importDataUsuario);

// Ruta para importar datos agendamiento
router.post('/importagendamiento', importecoageController.importDataAgendamiento);

// Ruta para importar datos agendamiento
router.post('/importauditoria', importecoageController.importDataAuditoria);

// Ruta para importar datos economia1
router.post('/impoeconomia1', importecoageController.importDataEconomia1);

// Ruta para importar datos economia2
router.post('/impoeconomia2', importecoageController.importDataEconomia2);

// Ruta para insertar datos
router.get('/insert', insertController.insertData);

// Ruta para actualizar el índice de los datos
router.get('/update-index', updateindexController.updateIndex);

module.exports = router;