const express = require("express");
const DiagnosticoController = require("../controllers/diagnostico.controller");

const router = express.Router();
/**
 * @swagger
 * components:
 *   schemas:
 *     Diagnostico:
 *       type: object
 *       required:
 *         - Nombre
 *         - CodigoCIE10
 *       properties:
 *         id:
 *           type: number
 *           description: El identificador único del Diagnostico
 *         Nombre:
 *           type: string
 *           description: Nombre del Diagnostico
 *         CodigoCIE10:
 *           type: string
 *           description: Codigo CIE10 del Diagnostico
 *       example:
 *         id: "1"
 *         Nombre: "FSDHGSDH"
 *         CodigoCIE10: "YEWTWEG"
 */
/**
 * @swagger
 * tags:
 *   name: Diagnostico
 *   description: API para gestionar Diagnostico
 */
/**
 * @swagger
 * /paciente/diagnostico:
 *   get:
 *     summary: Obtiene la lista de Diagnostico
 *     tags: [Diagnostico]
 *     responses:
 *       200:
 *         description: Lista de Diagnostico.
 *         content:
 *           application/json:
 *             schema:
 *               type: array
 *               items:
 *                 $ref: '#/components/schemas/Diagnostico'
 */
router.get("/", DiagnosticoController.getDiagnosticoAll);
/**
 * @swagger
 * /paciente/diagnostico/{id}:
 *   get:
 *     summary: Obtiene un Diagnostico por ID
 *     tags: [Diagnostico]
 *     parameters:
 *       - in: path
 *         name: id
 *         schema:
 *           type: number
 *         required: true
 *         description: ID del Diagnostico
 *     responses:
 *       200:
 *         description: Diagnostico encontrado.
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/Diagnostico'
 *       404:
 *         description: Diagnostico no encontrado.
 */
router.get("/:id", DiagnosticoController.getDiagnosticoById);
/**
 * @swagger
 * /paciente/diagnostico/create:
 *   post:
 *     summary: Crea un nuevo Diagnostico
 *     tags: [Diagnostico]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           schema:
 *             $ref: '#/components/schemas/Diagnostico'
 *     responses:
 *       201:
 *         description: Diagnostico creado exitosamente.
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/Diagnostico'
 */
router.post("/create", DiagnosticoController.createDiagnostico);
/**
 * @swagger
 * /paciente/diagnostico/update/{id}:
 *   put:
 *     summary: Actualiza un Diagnostico existente
 *     tags: [Diagnostico]
 *     parameters:
 *       - in: path
 *         name: id
 *         schema:
 *           type: number
 *         required: true
 *         description: ID del Diagnostico a actualizar
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           schema:
 *             $ref: '#/components/schemas/Diagnostico'
 *     responses:
 *       200:
 *         description: Diagnostico actualizado exitosamente.
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/Diagnostico'
 *       404:
 *         description: Diagnostico no encontrado.
 */
router.put("/update/:id", DiagnosticoController.updateDiagnostico);
/**
 * @swagger
 * /paciente/diagnostico/{id}:
 *   delete:
 *     summary: Elimina un Diagnostico por ID
 *     tags: [Diagnostico]
 *     parameters:
 *       - in: path
 *         name: id
 *         schema:
 *           type: number
 *         required: true
 *         description: ID del Diagnostico a eliminar
 *     responses:
 *       200:
 *         description: Diagnostico eliminado exitosamente.
 *       404:
 *         description: Diagnostico no encontrado.
 */
router.delete("/:id", DiagnosticoController.deleteDiagnostico);

module.exports = router;
