const express = require("express");
const EmpresaLaboratorioController = require("../controllers/empresalaboratorio.controller");

const router = express.Router();
/**
 * @swagger
 * components:
 *   schemas:
 *     EmpresaLaboratorio:
 *       type: object
 *       required:
 *         - Nombre
 *         - RUC
 *         - Direccion
 *         - Celular
 *         - Correo
 *       properties:
 *         id:
 *           type: number
 *           description: El identificador único del EmpresaLaboratorio
 *         Nombre:
 *           type: string
 *           description: Nombre de la Empresa Laboratorio
 *         RUC:
 *           type: string
 *           description: RUC de la Empresa Laboratorio
 *         Direccion:
 *           type: string
 *           description: Direccion de la Empresa Laboratorio
 *         Celular:
 *           type: string
 *           description: Celular de la Empresa Laboratorio
 *         Correo:
 *           type: string
 *           description: Correo de la Empresa Laboratorio
 *       example:
 *         id: "1"
 *         Nombre: "Laboratorio X"
 *         RUC: "20135143531"
 *         Direccion: "Jr. fdsaf 234"
 *         Celular: "9435325145"
 *         Correo: "laboratorio@lab.com"
 */
/**
 * @swagger
 * tags:
 *   name: EmpresaLaboratorio
 *   description: API para gestionar EmpresaLaboratorio
 */
/**
 * @swagger
 * /laboratorio/EmpresaLaboratorio:
 *   get:
 *     summary: Obtiene la lista de EmpresaLaboratorio
 *     tags: [EmpresaLaboratorio]
 *     responses:
 *       200:
 *         description: Lista de EmpresaLaboratorio.
 *         content:
 *           application/json:
 *             schema:
 *               type: array
 *               items:
 *                 $ref: '#/components/schemas/EmpresaLaboratorio'
 */
router.get("/", EmpresaLaboratorioController.getEmpresaLaboratorioAll);
/**
 * @swagger
 * /laboratorio/EmpresaLaboratorio/{id}:
 *   get:
 *     summary: Obtiene un EmpresaLaboratorio por ID
 *     tags: [EmpresaLaboratorio]
 *     parameters:
 *       - in: path
 *         name: id
 *         schema:
 *           type: number
 *         required: true
 *         description: ID del EmpresaLaboratorio
 *     responses:
 *       200:
 *         description: EmpresaLaboratorio encontrado.
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/EmpresaLaboratorio'
 *       404:
 *         description: EmpresaLaboratorio no encontrado.
 */
router.get("/:id", EmpresaLaboratorioController.getEmpresaLaboratorioById);
/**
 * @swagger
 * /laboratorio/EmpresaLaboratorio/create:
 *   post:
 *     summary: Crea un nuevo EmpresaLaboratorio
 *     tags: [EmpresaLaboratorio]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           schema:
 *             $ref: '#/components/schemas/EmpresaLaboratorio'
 *     responses:
 *       201:
 *         description: EmpresaLaboratorio creado exitosamente.
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/EmpresaLaboratorio'
 */
router.post("/create", EmpresaLaboratorioController.createEmpresaLaboratorio);
/**
 * @swagger
 * /laboratorio/EmpresaLaboratorio/update/{id}:
 *   put:
 *     summary: Actualiza un EmpresaLaboratorio existente
 *     tags: [EmpresaLaboratorio]
 *     parameters:
 *       - in: path
 *         name: id
 *         schema:
 *           type: number
 *         required: true
 *         description: ID del EmpresaLaboratorio a actualizar
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           schema:
 *             $ref: '#/components/schemas/EmpresaLaboratorio'
 *     responses:
 *       200:
 *         description: EmpresaLaboratorio actualizado exitosamente.
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/EmpresaLaboratorio'
 *       404:
 *         description: EmpresaLaboratorio no encontrado.
 */
router.put("/update/:id", EmpresaLaboratorioController.updateEmpresaLaboratorio);
/**
 * @swagger
 * /laboratorio/EmpresaLaboratorio/{id}:
 *   delete:
 *     summary: Elimina un EmpresaLaboratorio por ID
 *     tags: [EmpresaLaboratorio]
 *     parameters:
 *       - in: path
 *         name: id
 *         schema:
 *           type: number
 *         required: true
 *         description: ID del EmpresaLaboratorio a eliminar
 *     responses:
 *       200:
 *         description: EmpresaLaboratorio eliminado exitosamente.
 *       404:
 *         description: EmpresaLaboratorio no encontrado.
 */
router.delete("/:id", EmpresaLaboratorioController.deleteEmpresaLaboratorio);

module.exports = router;
