const express = require("express");
const EmpresaRadiografiaController = require("../controllers/empresaradiografia.controller");

const router = express.Router();
/**
 * @swagger
 * components:
 *   schemas:
 *     EmpresaRadiografia:
 *       type: object
 *       required:
 *         - Nombre
 *         - RUC
 *         - Direccion
 *         - Celular
 *         - Correo
 *       properties:
 *         id:
 *           type: number
 *           description: El identificador único del EmpresaRadiografia
 *         Nombre:
 *           type: string
 *           description: Nombre del EmpresaRadiografia
 *         RUC:
 *           type: string
 *           description: RUC del EmpresaRadiografia
 *         Direccion:
 *           type: string
 *           description: Direccion del EmpresaRadiografia
 *         Celular:
 *           type: string
 *           description: Celular del EmpresaRadiografia
 *         Correo:
 *           type: string
 *           description: Correo del EmpresaRadiografia
 *       example:
 *         id: "1"
 *         Nombre: "Empresa Radiografica Dental Dentosfdag"
 *         RUC: "20124214214"
 *         Direccion: "Jr. Radiografias r3r32"
 *         Celular: "95354352345"
 *         Correo: "radds23@radges.com"
 */
/**
 * @swagger
 * tags:
 *   name: EmpresaRadiografia
 *   description: API para gestionar EmpresaRadiografia
 */
/**
 * @swagger
 * /radiografia/EmpresaRadiografia:
 *   get:
 *     summary: Obtiene la lista de EmpresaRadiografia
 *     tags: [EmpresaRadiografia]
 *     responses:
 *       200:
 *         description: Lista de EmpresaRadiografia.
 *         content:
 *           application/json:
 *             schema:
 *               type: array
 *               items:
 *                 $ref: '#/components/schemas/EmpresaRadiografia'
 */
router.get("/", EmpresaRadiografiaController.getEmpresaRadiografiaAll);
/**
 * @swagger
 * /radiografia/EmpresaRadiografia/{id}:
 *   get:
 *     summary: Obtiene un EmpresaRadiografia por ID
 *     tags: [EmpresaRadiografia]
 *     parameters:
 *       - in: path
 *         name: id
 *         schema:
 *           type: number
 *         required: true
 *         description: ID del EmpresaRadiografia
 *     responses:
 *       200:
 *         description: EmpresaRadiografia encontrado.
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/EmpresaRadiografia'
 *       404:
 *         description: EmpresaRadiografia no encontrado.
 */
router.get("/:id", EmpresaRadiografiaController.getEmpresaRadiografiaById);
/**
 * @swagger
 * /radiografia/EmpresaRadiografia/create:
 *   post:
 *     summary: Crea un nuevo EmpresaRadiografia
 *     tags: [EmpresaRadiografia]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           schema:
 *             $ref: '#/components/schemas/EmpresaRadiografia'
 *     responses:
 *       201:
 *         description: EmpresaRadiografia creado exitosamente.
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/EmpresaRadiografia'
 */
router.post("/create", EmpresaRadiografiaController.createEmpresaRadiografia);
/**
 * @swagger
 * /radiografia/EmpresaRadiografia/update/{id}:
 *   put:
 *     summary: Actualiza un EmpresaRadiografia existente
 *     tags: [EmpresaRadiografia]
 *     parameters:
 *       - in: path
 *         name: id
 *         schema:
 *           type: number
 *         required: true
 *         description: ID del EmpresaRadiografia a actualizar
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           schema:
 *             $ref: '#/components/schemas/EmpresaRadiografia'
 *     responses:
 *       200:
 *         description: EmpresaRadiografia actualizado exitosamente.
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/EmpresaRadiografia'
 *       404:
 *         description: EmpresaRadiografia no encontrado.
 */
router.put("/update/:id", EmpresaRadiografiaController.updateEmpresaRadiografia);
/**
 * @swagger
 * /radiografia/EmpresaRadiografia/{id}:
 *   delete:
 *     summary: Elimina un EmpresaRadiografia por ID
 *     tags: [EmpresaRadiografia]
 *     parameters:
 *       - in: path
 *         name: id
 *         schema:
 *           type: number
 *         required: true
 *         description: ID del EmpresaRadiografia a eliminar
 *     responses:
 *       200:
 *         description: EmpresaRadiografia eliminado exitosamente.
 *       404:
 *         description: EmpresaRadiografia no encontrado.
 */
router.delete("/:id", EmpresaRadiografiaController.deleteEmpresaRadiografia);

module.exports = router;
