const express = require("express");
const EncuestaComplejaController = require("../controllers/encuestacompleja.controller");

const router = express.Router();
/**
 * @swagger
 * components:
 *   schemas:
 *     EncuestaCompleja:
 *       type: object
 *       required:
 *         - CondicionPaciente
 *         - Instalaciones
 *         - AtencionRecepcion
 *         - AtencionServicio
 *         - Valores
 *         - TiempoEspera
 *         - OdontologoClaro
 *         - OdontologoServicio
 *         - Cita
 *         - OdontologoAtendioQUIEN
 *         - AtencionOdontologo
 *         - AtencionTecnico
 *         - SolucionProblema
 *         - Gusto
 *         - Sugerencia
 *         - Recomendaria
 *       properties:
 *         id:
 *           type: number
 *           description: El identificador único de la encuesta
 *         CondicionPaciente:
 *           type: string
 *           description: Nombre de la EncuestaCompleja
 *         Instalaciones:
 *           type: string
 *           description: Tipo de EncuestaCompleja (Principal, sucursal, expancion y etc)
 *         AtencionRecepcion:
 *           type: string
 *           description: Direccion de la EncuestaCompleja
 *         AtencionServicio:
 *           type: string
 *           description: Referencia de la EncuestaCompleja
 *         Valores:
 *           type: string
 *           description: Telefono de la EncuestaCompleja
 *         TiempoEspera:
 *           type: string
 *           description: Celular de la EncuestaCompleja
 *         OdontologoClaro:
 *           type: string
 *           description: Encargado de la EncuestaCompleja
 *         OdontologoServicio:
 *           type: string
 *           description: Foto de la EncuestaCompleja
 *         Cita:
 *           type: string
 *           description: A que Empresa pertenece
 *         OdontologoAtendioQUIEN:
 *           type: string
 *           description: Celular de la EncuestaCompleja
 *         AtencionOdontologo:
 *           type: string
 *           description: Encargado de la EncuestaCompleja
 *         AtencionTecnico:
 *           type: string
 *           description: Foto de la EncuestaCompleja
 *         SolucionProblema:
 *           type: string
 *           description: Encargado de la EncuestaCompleja
 *         Gusto:
 *           type: string
 *           description: Foto de la EncuestaCompleja
 *         Sugerencia:
 *           type: string
 *           description: Encargado de la EncuestaCompleja
 *         Recomendaria:
 *           type: string
 *           description: Foto de la EncuestaCompleja
 *       example:
 *         id: "1"
 *         CondicionPaciente: "932050033"
 *         Instalaciones: "932050033"
 *         AtencionRecepcion: "932050033"
 *         AtencionServicio: "932050033"
 *         Valores: "932050033"
 *         TiempoEspera: "932050033"
 *         OdontologoClaro: "932050033"
 *         OdontologoServicio: "932050033"
 *         Cita: "932050033"
 *         OdontologoAtendioQUIEN: "932050033"
 *         AtencionOdontologo: "932050033"
 *         AtencionTecnico: "932050033"
 *         SolucionProblema: "932050033"
 *         Gusto: "932050033"
 *         Sugerencia: "932050033"
 *         Recomendaria: "932050033"
 */
/**
 * @swagger
 * tags:
 *   name: EncuestaCompleja
 *   description: API para gestionar EncuestaComplejas
 */
/**
 * @swagger
 * /encuestas/encuestacompleja:
 *   get:
 *     summary: Obtiene la lista de EncuestaComplejas
 *     tags: [EncuestaCompleja]
 *     responses:
 *       200:
 *         description: Lista de EncuestaComplejas.
 *         content:
 *           application/json:
 *             schema:
 *               type: array
 *               items:
 *                 $ref: '#/components/schemas/EncuestaCompleja'
 */
router.get("/", EncuestaComplejaController.getEncuestaComplejaAll);
/**
 * @swagger
 * /encuestas/encuestacompleja/{id}:
 *   get:
 *     summary: Obtiene un EncuestaCompleja por ID
 *     tags: [EncuestaCompleja]
 *     parameters:
 *       - in: path
 *         name: id
 *         schema:
 *           type: number
 *         required: true
 *         description: ID del EncuestaCompleja
 *     responses:
 *       200:
 *         description: EncuestaCompleja encontrado.
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/EncuestaCompleja'
 *       404:
 *         description: EncuestaCompleja no encontrado.
 */
router.get("/:id", EncuestaComplejaController.getEncuestaComplejaById);
/**
 * @swagger
 * /encuestas/encuestacompleja/create:
 *   post:
 *     summary: Crea un nuevo EncuestaCompleja
 *     tags: [EncuestaCompleja]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           schema:
 *             $ref: '#/components/schemas/EncuestaCompleja'
 *     responses:
 *       201:
 *         description: EncuestaCompleja creado exitosamente.
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/EncuestaCompleja'
 */
router.post("/create", EncuestaComplejaController.createEncuestaCompleja);
/**
 * @swagger
 * /encuestas/encuestacompleja/update/{id}:
 *   put:
 *     summary: Actualiza un EncuestaCompleja existente
 *     tags: [EncuestaCompleja]
 *     parameters:
 *       - in: path
 *         name: id
 *         schema:
 *           type: number
 *         required: true
 *         description: ID del EncuestaCompleja a actualizar
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           schema:
 *             $ref: '#/components/schemas/EncuestaCompleja'
 *     responses:
 *       200:
 *         description: EncuestaCompleja actualizado exitosamente.
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/EncuestaCompleja'
 *       404:
 *         description: EncuestaCompleja no encontrado.
 */
router.put("/update/:id", EncuestaComplejaController.updateEncuestaCompleja);
/**
 * @swagger
 * /encuestas/encuestacompleja/{id}:
 *   delete:
 *     summary: Elimina un EncuestaCompleja por ID
 *     tags: [EncuestaCompleja]
 *     parameters:
 *       - in: path
 *         name: id
 *         schema:
 *           type: number
 *         required: true
 *         description: ID del EncuestaCompleja a eliminar
 *     responses:
 *       200:
 *         description: EncuestaCompleja eliminado exitosamente.
 *       404:
 *         description: EncuestaCompleja no encontrado.
 */
router.delete("/:id", EncuestaComplejaController.deleteEncuestaCompleja);

module.exports = router;
