const express = require("express");
const EncuestaKidsController = require("../controllers/encuestakids.controller");

const router = express.Router();
/**
 * @swagger
 * components:
 *   schemas:
 *     EncuestaKids:
 *       type: object
 *       required:
 *         - Nombre
 *         - SalondeJuegos
 *         - Atencion
 *         - Tiempo
 *         - Volverias
 *       properties:
 *         id:
 *           type: number
 *           description: El identificador único de la encuesta
 *         Nombre:
 *           type: string
 *           description: Resumen de lo registrado
 *         SalondeJuegos:
 *           type: string
 *           description: Calificacion sobre la Sala de Juegos de los ninios
 *         Atencion:
 *           type: string
 *           description: Calificacion sobre la atencion proporcionada
 *         Tiempo:
 *           type: string
 *           description: Calificacion sobre el tiempo de atencion
 *         Volverias:
 *           type: string
 *           description: Calificacion sobre si el cliente volveria o no
 *       example:
 *         id: "1"
 *         Nombre: 'Pendiente'
 *         SalondeJuegos: "Principal"
 *         Atencion: "Calle Real Nº 716 - 2do Piso El Tambo – Huancayo"
 *         Tiempo: "Costado de la DIRESA"
 *         Volverias: "(064)249898"
 */
/**
 * @swagger
 * tags:
 *   name: EncuestaKids
 *   description: API para gestionar EncuestaKidss
 */
/**
 * @swagger
 * /encuestas/encuestakids:
 *   get:
 *     summary: Obtiene la lista de EncuestaKidss
 *     tags: [EncuestaKids]
 *     responses:
 *       200:
 *         description: Lista de EncuestaKidss.
 *         content:
 *           application/json:
 *             schema:
 *               type: array
 *               items:
 *                 $ref: '#/components/schemas/EncuestaKids'
 */
router.get("/", EncuestaKidsController.getEncuestaKidsAll);
/**
 * @swagger
 * /encuestas/encuestakids/{id}:
 *   get:
 *     summary: Obtiene un EncuestaKids por ID
 *     tags: [EncuestaKids]
 *     parameters:
 *       - in: path
 *         name: id
 *         schema:
 *           type: number
 *         required: true
 *         description: ID del EncuestaKids
 *     responses:
 *       200:
 *         description: EncuestaKids encontrado.
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/EncuestaKids'
 *       404:
 *         description: EncuestaKids no encontrado.
 */
router.get("/:id", EncuestaKidsController.getEncuestaKidsById);
/**
 * @swagger
 * /encuestas/encuestakids/create:
 *   post:
 *     summary: Crea un nuevo EncuestaKids
 *     tags: [EncuestaKids]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           schema:
 *             $ref: '#/components/schemas/EncuestaKids'
 *     responses:
 *       201:
 *         description: EncuestaKids creado exitosamente.
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/EncuestaKids'
 */
router.post("/create", EncuestaKidsController.createEncuestaKids);
/**
 * @swagger
 * /encuestas/encuestakids/update/{id}:
 *   put:
 *     summary: Actualiza un EncuestaKids existente
 *     tags: [EncuestaKids]
 *     parameters:
 *       - in: path
 *         name: id
 *         schema:
 *           type: number
 *         required: true
 *         description: ID del EncuestaKids a actualizar
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           schema:
 *             $ref: '#/components/schemas/EncuestaKids'
 *     responses:
 *       200:
 *         description: EncuestaKids actualizado exitosamente.
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/EncuestaKids'
 *       404:
 *         description: EncuestaKids no encontrado.
 */
router.put("/update/:id", EncuestaKidsController.updateEncuestaKids);
/**
 * @swagger
 * /encuestas/encuestakids/{id}:
 *   delete:
 *     summary: Elimina un EncuestaKids por ID
 *     tags: [EncuestaKids]
 *     parameters:
 *       - in: path
 *         name: id
 *         schema:
 *           type: number
 *         required: true
 *         description: ID del EncuestaKids a eliminar
 *     responses:
 *       200:
 *         description: EncuestaKids eliminado exitosamente.
 *       404:
 *         description: EncuestaKids no encontrado.
 */
router.delete("/:id", EncuestaKidsController.deleteEncuestaKids);

module.exports = router;
