const express = require("express");
const EncuestaSimpleController = require("../controllers/encuestasimple.controller");

const router = express.Router();
/**
 * @swagger
 * components:
 *   schemas:
 *     EncuestaSimple:
 *       type: object
 *       required:
 *         - Instalaciones
 *         - Atencion
 *         - DuracciondeAtencion
 *         - InformacionBrindada
 *         - Organizacion
 *         - Trabajo
 *       properties:
 *         id:
 *           type: number
 *           description: El identificador único de la encuesta
 *         Instalaciones:
 *           type: string
 *           description: Calificacion sobre las Instalaciones
 *         Atencion:
 *           type: string
 *           description: Calificacion sobre la Atencion
 *         DuracciondeAtencion:
 *           type: string
 *           description: Calificacion sobre la duracion de la atencion
 *         InformacionBrindada:
 *           type: string
 *           description: Calificacion sobre la informacion brindada
 *         Organizacion:
 *           type: string
 *           description: Calificacion sobre la organizacion de la empresa
 *         Trabajo:
 *           type: string
 *           description: Calificacion sobre el trabajo que noto
 *       example:
 *         id: "1"
 *         Instalaciones: 'Pendiente'
 *         Atencion: "Principal"
 *         DuracciondeAtencion: "Costado de la DIRESA"
 *         InformacionBrindada: "(064)249898"
 *         Organizacion: "932050033"
 *         Trabajo: ""
 */
/**
 * @swagger
 * tags:
 *   name: EncuestaSimple
 *   description: API para gestionar EncuestaSimples
 */
/**
 * @swagger
 * /encuestas/encuestasimple:
 *   get:
 *     summary: Obtiene la lista de EncuestaSimples
 *     tags: [EncuestaSimple]
 *     responses:
 *       200:
 *         description: Lista de EncuestaSimples.
 *         content:
 *           application/json:
 *             schema:
 *               type: array
 *               items:
 *                 $ref: '#/components/schemas/EncuestaSimple'
 */
router.get("/", EncuestaSimpleController.getEncuestaSimpleAll);
/**
 * @swagger
 * /encuestas/encuestasimple/{id}:
 *   get:
 *     summary: Obtiene un EncuestaSimple por ID
 *     tags: [EncuestaSimple]
 *     parameters:
 *       - in: path
 *         name: id
 *         schema:
 *           type: number
 *         required: true
 *         description: ID del EncuestaSimple
 *     responses:
 *       200:
 *         description: EncuestaSimple encontrado.
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/EncuestaSimple'
 *       404:
 *         description: EncuestaSimple no encontrado.
 */
router.get("/:id", EncuestaSimpleController.getEncuestaSimpleById);
/**
 * @swagger
 * /encuestas/encuestasimple/create:
 *   post:
 *     summary: Crea un nuevo EncuestaSimple
 *     tags: [EncuestaSimple]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           schema:
 *             $ref: '#/components/schemas/EncuestaSimple'
 *     responses:
 *       201:
 *         description: EncuestaSimple creado exitosamente.
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/EncuestaSimple'
 */
router.post("/create", EncuestaSimpleController.createEncuestaSimple);
/**
 * @swagger
 * /encuestas/encuestasimple/update/{id}:
 *   put:
 *     summary: Actualiza un EncuestaSimple existente
 *     tags: [EncuestaSimple]
 *     parameters:
 *       - in: path
 *         name: id
 *         schema:
 *           type: number
 *         required: true
 *         description: ID del EncuestaSimple a actualizar
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           schema:
 *             $ref: '#/components/schemas/EncuestaSimple'
 *     responses:
 *       200:
 *         description: EncuestaSimple actualizado exitosamente.
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/EncuestaSimple'
 *       404:
 *         description: EncuestaSimple no encontrado.
 */
router.put("/update/:id", EncuestaSimpleController.updateEncuestaSimple);
/**
 * @swagger
 * /encuestas/encuestasimple/{id}:
 *   delete:
 *     summary: Elimina un EncuestaSimple por ID
 *     tags: [EncuestaSimple]
 *     parameters:
 *       - in: path
 *         name: id
 *         schema:
 *           type: number
 *         required: true
 *         description: ID del EncuestaSimple a eliminar
 *     responses:
 *       200:
 *         description: EncuestaSimple eliminado exitosamente.
 *       404:
 *         description: EncuestaSimple no encontrado.
 */
router.delete("/:id", EncuestaSimpleController.deleteEncuestaSimple);

module.exports = router;
