const express = require("express");
const GeneroController = require("../controllers/genero.controller");

const router = express.Router();

router.get("/", GeneroController.getGeneroAll);
router.get("/:id", GeneroController.getGeneroById);
router.post("/create", GeneroController.createGenero);
router.put("/update/:id", GeneroController.updateGenero);
router.delete("/:id", GeneroController.deleteGenero);

module.exports = router;
