const express = require("express");
const HallazgoController = require("../controllers/hallazgo.controller");

const router = express.Router();

router.get("/", HallazgoController.getHallazgoAll);
router.get("/:id", HallazgoController.getHallazgoById);
router.post("/create", HallazgoController.createHallazgo);
router.put("/update/:id", HallazgoController.updateHallazgo);
router.delete("/:id", HallazgoController.deleteHallazgo);

module.exports = router;