const express = require("express");
const ItemResultadoLaboratorioController = require("../controllers/itemresultadolaboratorio.controller");
const {verifyToken} = require('../middlewares/auth.middleware'); // Importar middleware

const router = express.Router();
/**
 * @swagger
 * components:
 *   schemas:
 *     ItemResultadoLaboratorio:
 *       type: object
 *       required:
 *         - Observacion
 *         - ValorResultado
 *         - PeticionLaboratorioId
 *         - SubItemLaboratorioId
 *         - ResultadoLaboratorioId
 *       properties:
 *         id:
 *           type: number
 *           description: El identificador único del ItemResultadoLaboratorio
 *         Observacion:
 *           type: string
 *           description: Observacion si esque la hay
 *         ValorResultado:
 *           type: string
 *           description: Valor del Resultado
 *         PeticionLaboratorioId:
 *           type: string
 *           description: Relacion del ItemResultadoLaboratorio con la Peticion
 *         SubItemLaboratorioId:
 *           type: string
 *           description: Relacion del ItemResultadoLaboratorio con el SubItem
 *         ResultadoLaboratorioId:
 *           type: string
 *           description: Relacion del ItemResultadoLaboratorio con el Resultado
 *       example:
 *         id: "1"
 *         Observacion: "Ninguna"
 *         ValorResultado: "19.4"
 *         PeticionLaboratorioId: "1"
 *         SubItemLaboratorioId: "1"
 *         ResultadoLaboratorioId: "1"
 */
/**
 * @swagger
 * tags:
 *   name: ItemResultadoLaboratorio
 *   description: API para gestionar ItemResultadoLaboratorio
 */
/**
 * @swagger
 * /laboratorio/itemresultado:
 *   get:
 *     summary: Obtiene la lista de ItemResultadoLaboratorio
 *     tags: [ItemResultadoLaboratorio]
 *     responses:
 *       200:
 *         description: Lista de ItemResultadoLaboratorio.
 *         content:
 *           application/json:
 *             schema:
 *               type: array
 *               items:
 *                 $ref: '#/components/schemas/ItemResultadoLaboratorio'
 */
router.get("/", verifyToken, ItemResultadoLaboratorioController.getItemResultadoLaboratorioAll);
/**
 * @swagger
 * /laboratorio/itemresultado/{id}:
 *   get:
 *     summary: Obtiene un ItemResultadoLaboratorio por ID
 *     tags: [ItemResultadoLaboratorio]
 *     parameters:
 *       - in: path
 *         name: id
 *         schema:
 *           type: number
 *         required: true
 *         description: ID del ItemResultadoLaboratorio
 *     responses:
 *       200:
 *         description: ItemResultadoLaboratorio encontrado.
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/ItemResultadoLaboratorio'
 *       404:
 *         description: ItemResultadoLaboratorio no encontrado.
 */
router.get("/:id", verifyToken, ItemResultadoLaboratorioController.getItemResultadoLaboratorioById);
/**
 * @swagger
 * /laboratorio/itemresultado/create:
 *   post:
 *     summary: Crea un nuevo ItemResultadoLaboratorio
 *     tags: [ItemResultadoLaboratorio]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           schema:
 *             $ref: '#/components/schemas/ItemResultadoLaboratorio'
 *     responses:
 *       201:
 *         description: ItemResultadoLaboratorio creado exitosamente.
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/ItemResultadoLaboratorio'
 */
router.post("/create", verifyToken, ItemResultadoLaboratorioController.createItemResultadoLaboratorio);
/**
 * @swagger
 * /laboratorio/itemresultado/update/{id}:
 *   put:
 *     summary: Actualiza un ItemResultadoLaboratorio existente
 *     tags: [ItemResultadoLaboratorio]
 *     parameters:
 *       - in: path
 *         name: id
 *         schema:
 *           type: number
 *         required: true
 *         description: ID del ItemResultadoLaboratorio a actualizar
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           schema:
 *             $ref: '#/components/schemas/ItemResultadoLaboratorio'
 *     responses:
 *       200:
 *         description: ItemResultadoLaboratorio actualizado exitosamente.
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/ItemResultadoLaboratorio'
 *       404:
 *         description: ItemResultadoLaboratorio no encontrado.
 */
router.put("/update/:id", verifyToken, ItemResultadoLaboratorioController.updateItemResultadoLaboratorio);
/**
 * @swagger
 * /laboratorio/itemresultado/{id}:
 *   delete:
 *     summary: Elimina un ItemResultadoLaboratorio por ID
 *     tags: [ItemResultadoLaboratorio]
 *     parameters:
 *       - in: path
 *         name: id
 *         schema:
 *           type: number
 *         required: true
 *         description: ID del ItemResultadoLaboratorio a eliminar
 *     responses:
 *       200:
 *         description: ItemResultadoLaboratorio eliminado exitosamente.
 *       404:
 *         description: ItemResultadoLaboratorio no encontrado.
 */
router.delete("/:id", verifyToken, ItemResultadoLaboratorioController.deleteItemResultadoLaboratorio);
/**
 * @swagger
 * /laboratorio/itemresultado/filtro/peticion/{peticion}:
 *   get:
 *     summary: Obtiene un ItemResultadoLaboratorio por peticion
 *     tags: [ItemResultadoLaboratorio]
 *     parameters:
 *       - in: path
 *         name: peticion
 *         schema:
 *           type: number
 *         required: true
 *         description: Identificador del peticion
 *     responses:
 *       200:
 *         description: ItemResultadoLaboratorioes del peticion encontrados.
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/ItemResultadoLaboratorio'
 *       404:
 *         description: ItemResultadoLaboratorio no encontrado.
 */
// 🔍 Rutas individuales para búsqueda
router.get("/filtro/peticion/:peticion", verifyToken, ItemResultadoLaboratorioController.getItemResultadoLaboratorioByPeticionLaboratorio);
/**
 * @swagger
 * /laboratorio/itemresultado/filtro/subitem/{subitem}:
 *   get:
 *     summary: Obtiene un ItemResultadoLaboratorio por subitem
 *     tags: [ItemResultadoLaboratorio]
 *     parameters:
 *       - in: path
 *         name: subitem
 *         schema:
 *           type: number
 *         required: true
 *         description: Identificador del subitem
 *     responses:
 *       200:
 *         description: ItemResultadoLaboratorioes del subitem encontrados.
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/ItemResultadoLaboratorio'
 *       404:
 *         description: ItemResultadoLaboratorio no encontrado.
 */
// 🔍 Rutas individuales para búsqueda
router.get("/filtro/subitem/:subitem", verifyToken, ItemResultadoLaboratorioController.getItemResultadoLaboratorioBySubItem);
/**
 * @swagger
 * /laboratorio/itemresultado/filtro/resultadolaboratorio/{resultadolaboratorio}:
 *   get:
 *     summary: Obtiene un ItemResultadoLaboratorio por resultadolaboratorio
 *     tags: [ItemResultadoLaboratorio]
 *     parameters:
 *       - in: path
 *         name: resultadolaboratorio
 *         schema:
 *           type: number
 *         required: true
 *         description: Identificador del resultadolaboratorio
 *     responses:
 *       200:
 *         description: ItemResultadoLaboratorioes del resultadolaboratorio encontrados.
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/ItemResultadoLaboratorio'
 *       404:
 *         description: ItemResultadoLaboratorio no encontrado.
 */
// 🔍 Rutas individuales para búsqueda
router.get("/filtro/resultadolaboratorio/:resultadolaboratorio", verifyToken, ItemResultadoLaboratorioController.getItemResultadoLaboratorioByResultadoLaboratorio);

module.exports = router;
