const express = require("express");
const ItemResultadoRadiografiaController = require("../controllers/itemresultadoradiografia.controller");
const {verifyToken} = require('../middlewares/auth.middleware'); // Importar middleware

const router = express.Router();
/**
 * @swagger
 * components:
 *   schemas:
 *     ItemResultadoRadiografia:
 *       type: object
 *       required:
 *         - Observacion
 *         - RutaImagenRadiografica
 *         - PeticionRadiografiaId
 *         - ResultadoRadiografiaId
 *       properties:
 *         id:
 *           type: number
 *           description: El identificador único del ItemResultadoRadiografia
 *         Observacion:
 *           type: string
 *           description: Observacion del ItemResultadoRadiografia
 *         RutaImagenRadiografica:
 *           type: string
 *           description: Ruta Imagen Radiografica del ItemResultadoRadiografia
 *         PeticionRadiografiaId:
 *           type: string
 *           description: Peticion Radiografia del ItemResultadoRadiografia
 *         ResultadoRadiografiaId:
 *           type: string
 *           description: Resultado Radiografia del ItemResultadoRadiografia
 *       example:
 *         id: "1"
 *         Observacion: "Ninguna"
 *         RutaImagenRadiografica: "./imagenradio/fdsaf.jpg"
 *         PeticionRadiografiaId: "1"
 *         ResultadoRadiografiaId: "1"
 */
/**
 * @swagger
 * tags:
 *   name: ItemResultadoRadiografia
 *   description: API para gestionar ItemResultadoRadiografia
 */
/**
 * @swagger
 * /radiografia/itemresultado:
 *   get:
 *     summary: Obtiene la lista de ItemResultadoRadiografia
 *     tags: [ItemResultadoRadiografia]
 *     responses:
 *       200:
 *         description: Lista de ItemResultadoRadiografia.
 *         content:
 *           application/json:
 *             schema:
 *               type: array
 *               items:
 *                 $ref: '#/components/schemas/ItemResultadoRadiografia'
 */
router.get("/", verifyToken, ItemResultadoRadiografiaController.getItemResultadoRadiografiaAll);
/**
 * @swagger
 * /radiografia/itemresultado/{id}:
 *   get:
 *     summary: Obtiene un ItemResultadoRadiografia por ID
 *     tags: [ItemResultadoRadiografia]
 *     parameters:
 *       - in: path
 *         name: id
 *         schema:
 *           type: number
 *         required: true
 *         description: ID del ItemResultadoRadiografia
 *     responses:
 *       200:
 *         description: ItemResultadoRadiografia encontrado.
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/ItemResultadoRadiografia'
 *       404:
 *         description: ItemResultadoRadiografia no encontrado.
 */
router.get("/:id", verifyToken, ItemResultadoRadiografiaController.getItemResultadoRadiografiaById);
/**
 * @swagger
 * /radiografia/itemresultado/create:
 *   post:
 *     summary: Crea un nuevo ItemResultadoRadiografia
 *     tags: [ItemResultadoRadiografia]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           schema:
 *             $ref: '#/components/schemas/ItemResultadoRadiografia'
 *     responses:
 *       201:
 *         description: ItemResultadoRadiografia creado exitosamente.
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/ItemResultadoRadiografia'
 */
router.post("/create", verifyToken, ItemResultadoRadiografiaController.createItemResultadoRadiografia);
/**
 * @swagger
 * /radiografia/itemresultado/update/{id}:
 *   put:
 *     summary: Actualiza un ItemResultadoRadiografia existente
 *     tags: [ItemResultadoRadiografia]
 *     parameters:
 *       - in: path
 *         name: id
 *         schema:
 *           type: number
 *         required: true
 *         description: ID del ItemResultadoRadiografia a actualizar
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           schema:
 *             $ref: '#/components/schemas/ItemResultadoRadiografia'
 *     responses:
 *       200:
 *         description: ItemResultadoRadiografia actualizado exitosamente.
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/ItemResultadoRadiografia'
 *       404:
 *         description: ItemResultadoRadiografia no encontrado.
 */
router.put("/update/:id", verifyToken, ItemResultadoRadiografiaController.updateItemResultadoRadiografia);
/**
 * @swagger
 * /radiografia/itemresultado/{id}:
 *   delete:
 *     summary: Elimina un ItemResultadoRadiografia por ID
 *     tags: [ItemResultadoRadiografia]
 *     parameters:
 *       - in: path
 *         name: id
 *         schema:
 *           type: number
 *         required: true
 *         description: ID del ItemResultadoRadiografia a eliminar
 *     responses:
 *       200:
 *         description: ItemResultadoRadiografia eliminado exitosamente.
 *       404:
 *         description: ItemResultadoRadiografia no encontrado.
 */
router.delete("/:id", verifyToken, ItemResultadoRadiografiaController.deleteItemResultadoRadiografia);
/**
 * @swagger
 * /radiografia/itemresultado/filtro/peticion/{peticion}:
 *   get:
 *     summary: Obtiene un ItemResultadoRadiografia por peticion
 *     tags: [ItemResultadoRadiografia]
 *     parameters:
 *       - in: path
 *         name: peticion
 *         schema:
 *           type: number
 *         required: true
 *         description: Identificador del peticion
 *     responses:
 *       200:
 *         description: ItemResultadoRadiografiaes del peticion encontrados.
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/ItemResultadoRadiografia'
 *       404:
 *         description: ItemResultadoRadiografia no encontrado.
 */
// 🔍 Rutas individuales para búsqueda
router.get("/filtro/peticion/:peticion", verifyToken, ItemResultadoRadiografiaController.getItemResultadoRadiografiaByPeticionRadiografia);
/**
 * @swagger
 * /radiografia/itemresultado/filtro/resultado/{resultado}:
 *   get:
 *     summary: Obtiene un ItemResultadoRadiografia por resultado
 *     tags: [ItemResultadoRadiografia]
 *     parameters:
 *       - in: path
 *         name: resultado
 *         schema:
 *           type: number
 *         required: true
 *         description: Identificador del resultado
 *     responses:
 *       200:
 *         description: ItemResultadoRadiografiaes del resultado encontrados.
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/ItemResultadoRadiografia'
 *       404:
 *         description: ItemResultadoRadiografia no encontrado.
 */
// 🔍 Rutas individuales para búsqueda
router.get("/filtro/resultado/:resultado", verifyToken, ItemResultadoRadiografiaController.getItemResultadoRadiografiaByResultadoRadiografia);

module.exports = router;
