const express = require("express");
const LaboratorioController = require("../controllers/laboratorio.controller");

const router = express.Router();
/**
 * @swagger
 * components:
 *   schemas:
 *     Laboratorio:
 *       type: object
 *       required:
 *         - Nombre
 *       properties:
 *         id:
 *           type: number
 *           description: El identificador único del Laboratorio
 *         Nombre:
 *           type: string
 *           description: Nombre del Laboratorio
 *       example:
 *         id: "1"
 *         Nombre: "Hematologia"
 */
/**
 * @swagger
 * tags:
 *   name: Laboratorio
 *   description: API para gestionar Laboratorio
 */
/**
 * @swagger
 * /laboratorio/Laboratorio:
 *   get:
 *     summary: Obtiene la lista de Laboratorio
 *     tags: [Laboratorio]
 *     responses:
 *       200:
 *         description: Lista de Laboratorio.
 *         content:
 *           application/json:
 *             schema:
 *               type: array
 *               items:
 *                 $ref: '#/components/schemas/Laboratorio'
 */
router.get("/", LaboratorioController.getLaboratorioAll);
/**
 * @swagger
 * /laboratorio/Laboratorio/{id}:
 *   get:
 *     summary: Obtiene un Laboratorio por ID
 *     tags: [Laboratorio]
 *     parameters:
 *       - in: path
 *         name: id
 *         schema:
 *           type: number
 *         required: true
 *         description: ID del Laboratorio
 *     responses:
 *       200:
 *         description: Laboratorio encontrado.
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/Laboratorio'
 *       404:
 *         description: Laboratorio no encontrado.
 */
router.get("/:id", LaboratorioController.getLaboratorioById);
/**
 * @swagger
 * /laboratorio/Laboratorio/create:
 *   post:
 *     summary: Crea un nuevo Laboratorio
 *     tags: [Laboratorio]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           schema:
 *             $ref: '#/components/schemas/Laboratorio'
 *     responses:
 *       201:
 *         description: Laboratorio creado exitosamente.
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/Laboratorio'
 */
router.post("/create", LaboratorioController.createLaboratorio);
/**
 * @swagger
 * /laboratorio/Laboratorio/update/{id}:
 *   put:
 *     summary: Actualiza un Laboratorio existente
 *     tags: [Laboratorio]
 *     parameters:
 *       - in: path
 *         name: id
 *         schema:
 *           type: number
 *         required: true
 *         description: ID del Laboratorio a actualizar
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           schema:
 *             $ref: '#/components/schemas/Laboratorio'
 *     responses:
 *       200:
 *         description: Laboratorio actualizado exitosamente.
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/Laboratorio'
 *       404:
 *         description: Laboratorio no encontrado.
 */
router.put("/update/:id", LaboratorioController.updateLaboratorio);
/**
 * @swagger
 * /laboratorio/Laboratorio/{id}:
 *   delete:
 *     summary: Elimina un Laboratorio por ID
 *     tags: [Laboratorio]
 *     parameters:
 *       - in: path
 *         name: id
 *         schema:
 *           type: number
 *         required: true
 *         description: ID del Laboratorio a eliminar
 *     responses:
 *       200:
 *         description: Laboratorio eliminado exitosamente.
 *       404:
 *         description: Laboratorio no encontrado.
 */
router.delete("/:id", LaboratorioController.deleteLaboratorio);

module.exports = router;
