const express = require("express");
const PeriodoController = require("../controllers/periodo.controller");

const router = express.Router();

router.get("/", PeriodoController.getPeriodoAll);
router.get("/:id", PeriodoController.getPeriodoById);
router.post("/create", PeriodoController.createPeriodo);
router.put("/update/:id", PeriodoController.updatePeriodo);
router.delete("/:id", PeriodoController.deletePeriodo);

module.exports = router;