const express = require("express");
const ProcedimientoController = require("../controllers/procedimiento.controller");

const router = express.Router();
/**
 * @swagger
 * components:
 *   schemas:
 *     Procedimiento:
 *       type: object
 *       required:
 *         - Nombre
 *         - CodigoCIE10
 *       properties:
 *         id:
 *           type: number
 *           description: El identificador único del Procedimiento
 *         Nombre:
 *           type: string
 *           description: Nombre del Procedimiento
 *         CodigoCIE10:
 *           type: string
 *           description: Codigo CIE10 del Procedimiento
 *       example:
 *         id: "1"
 *         Nombre: "FSDHGSDH"
 *         CodigoCIE10: "YEWTWEG"
 */
/**
 * @swagger
 * tags:
 *   name: Procedimiento
 *   description: API para gestionar Procedimiento
 */
/**
 * @swagger
 * /paciente/Procedimiento:
 *   get:
 *     summary: Obtiene la lista de Procedimiento
 *     tags: [Procedimiento]
 *     responses:
 *       200:
 *         description: Lista de Procedimiento.
 *         content:
 *           application/json:
 *             schema:
 *               type: array
 *               items:
 *                 $ref: '#/components/schemas/Procedimiento'
 */
router.get("/", ProcedimientoController.getProcedimientoAll);
/**
 * @swagger
 * /paciente/Procedimiento/{id}:
 *   get:
 *     summary: Obtiene un Procedimiento por ID
 *     tags: [Procedimiento]
 *     parameters:
 *       - in: path
 *         name: id
 *         schema:
 *           type: number
 *         required: true
 *         description: ID del Procedimiento
 *     responses:
 *       200:
 *         description: Procedimiento encontrado.
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/Procedimiento'
 *       404:
 *         description: Procedimiento no encontrado.
 */
router.get("/:id", ProcedimientoController.getProcedimientoById);
/**
 * @swagger
 * /paciente/Procedimiento/create:
 *   post:
 *     summary: Crea un nuevo Procedimiento
 *     tags: [Procedimiento]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           schema:
 *             $ref: '#/components/schemas/Procedimiento'
 *     responses:
 *       201:
 *         description: Procedimiento creado exitosamente.
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/Procedimiento'
 */
router.post("/create", ProcedimientoController.createProcedimiento);
/**
 * @swagger
 * /paciente/Procedimiento/update/{id}:
 *   put:
 *     summary: Actualiza un Procedimiento existente
 *     tags: [Procedimiento]
 *     parameters:
 *       - in: path
 *         name: id
 *         schema:
 *           type: number
 *         required: true
 *         description: ID del Procedimiento a actualizar
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           schema:
 *             $ref: '#/components/schemas/Procedimiento'
 *     responses:
 *       200:
 *         description: Procedimiento actualizado exitosamente.
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/Procedimiento'
 *       404:
 *         description: Procedimiento no encontrado.
 */
router.put("/update/:id", ProcedimientoController.updateProcedimiento);
/**
 * @swagger
 * /paciente/Procedimiento/{id}:
 *   delete:
 *     summary: Elimina un Procedimiento por ID
 *     tags: [Procedimiento]
 *     parameters:
 *       - in: path
 *         name: id
 *         schema:
 *           type: number
 *         required: true
 *         description: ID del Procedimiento a eliminar
 *     responses:
 *       200:
 *         description: Procedimiento eliminado exitosamente.
 *       404:
 *         description: Procedimiento no encontrado.
 */
router.delete("/:id", ProcedimientoController.deleteProcedimiento);

module.exports = router;
