const express = require("express");
const RadiografiaController = require("../controllers/radiografia.controller");

const router = express.Router();
/**
 * @swagger
 * components:
 *   schemas:
 *     Radiografia:
 *       type: object
 *       required:
 *         - Nombre
 *       properties:
 *         id:
 *           type: number
 *           description: El identificador único del Radiografia
 *         Nombre:
 *           type: string
 *           description: Nombre del Radiografia
 *       example:
 *         id: "1"
 *         Nombre: "Radiografia Bucal"
 */
/**
 * @swagger
 * tags:
 *   name: Radiografia
 *   description: API para gestionar Radiografia
 */
/**
 * @swagger
 * /radiografia/Radiografia:
 *   get:
 *     summary: Obtiene la lista de Radiografia
 *     tags: [Radiografia]
 *     responses:
 *       200:
 *         description: Lista de Radiografia.
 *         content:
 *           application/json:
 *             schema:
 *               type: array
 *               items:
 *                 $ref: '#/components/schemas/Radiografia'
 */
router.get("/", RadiografiaController.getRadiografiaAll);
/**
 * @swagger
 * /radiografia/Radiografia/{id}:
 *   get:
 *     summary: Obtiene un Radiografia por ID
 *     tags: [Radiografia]
 *     parameters:
 *       - in: path
 *         name: id
 *         schema:
 *           type: number
 *         required: true
 *         description: ID del Radiografia
 *     responses:
 *       200:
 *         description: Radiografia encontrado.
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/Radiografia'
 *       404:
 *         description: Radiografia no encontrado.
 */
router.get("/:id", RadiografiaController.getRadiografiaById);
/**
 * @swagger
 * /radiografia/Radiografia/create:
 *   post:
 *     summary: Crea un nuevo Radiografia
 *     tags: [Radiografia]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           schema:
 *             $ref: '#/components/schemas/Radiografia'
 *     responses:
 *       201:
 *         description: Radiografia creado exitosamente.
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/Radiografia'
 */
router.post("/create", RadiografiaController.createRadiografia);
/**
 * @swagger
 * /radiografia/Radiografia/update/{id}:
 *   put:
 *     summary: Actualiza un Radiografia existente
 *     tags: [Radiografia]
 *     parameters:
 *       - in: path
 *         name: id
 *         schema:
 *           type: number
 *         required: true
 *         description: ID del Radiografia a actualizar
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           schema:
 *             $ref: '#/components/schemas/Radiografia'
 *     responses:
 *       200:
 *         description: Radiografia actualizado exitosamente.
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/Radiografia'
 *       404:
 *         description: Radiografia no encontrado.
 */
router.put("/update/:id", RadiografiaController.updateRadiografia);
/**
 * @swagger
 * /radiografia/Radiografia/{id}:
 *   delete:
 *     summary: Elimina un Radiografia por ID
 *     tags: [Radiografia]
 *     parameters:
 *       - in: path
 *         name: id
 *         schema:
 *           type: number
 *         required: true
 *         description: ID del Radiografia a eliminar
 *     responses:
 *       200:
 *         description: Radiografia eliminado exitosamente.
 *       404:
 *         description: Radiografia no encontrado.
 */
router.delete("/:id", RadiografiaController.deleteRadiografia);

module.exports = router;
