const express = require("express");
const VinculacionController = require("../controllers/reporte.controller");

const router = express.Router();

// obtener usuarios por fecha de cumpleaños
router.post("/usuarios/birthday", VinculacionController.getUsersByBirthday);

// Obtener pacientes por fecha de cumpleaños
router.post("/pacientes/birthday", VinculacionController.getPacientesByBirthday);

// Obtener total de egresos por sede en un rango de fechas
router.post("/egresos/total/sede", VinculacionController.getEgresoTotalBySede);

// Obtener total de ingresos por sede en un rango de fechas
router.post("/ingresos/total/sede", VinculacionController.getIngresoTotalBySede);

// Obtener total de ingresos por sede y odontologo en un rango de fechas
router.post("/ingresos/total/sede-odontologo", VinculacionController.getIngresoTotalBySedeAndOdontologo);

module.exports = router;