const express = require("express");
const subcategoriainventarioController = require("../controllers/subcategoriainventario.controller");

const router = express.Router();
/**
 * @swagger
 * components:
 *   schemas:
 *     SubCategoriaInventario:
 *       type: object
 *       required:
 *         - Nombre
 *         - Descripcion
 *         - CategoriaInventarioId
 *       properties:
 *         id:
 *           type: number
 *           description: El identificador único de la Sub Categoria Inventario
 *         Nombre:
 *           type: string
 *           description: Nombre de la Sub Categoria
 *         Descripcion:
 *           type: string
 *           description: Descripcion de la Sub Categoria
 *         CategoriaInventarioId:
 *           type: number
 *           description: A que Categoria Pertenece
 *       example:
 *         id: "1"
 *         Nombre: "Instrumentos de Exploración y Tratamiento"
 *         Descripcion: "Instrumentos de Exploración y Tratamiento FDASFDSFDSFA"
 *         CategoriaInventarioId: "1"
 */
/**
 * @swagger
 * tags:
 *   name: SubCategoriaInventario
 *   description: API para gestionar SubCategoriaInventarios
 */
/**
 * @swagger
 * /inventario/subcategoria:
 *   get:
 *     summary: Obtiene la lista de SubCategoriaInventarios
 *     tags: [SubCategoriaInventario]
 *     responses:
 *       200:
 *         description: Lista de SubCategoriaInventarios.
 *         content:
 *           application/json:
 *             schema:
 *               type: array
 *               items:
 *                 $ref: '#/components/schemas/SubCategoriaInventario'
 */
router.get("/", subcategoriainventarioController.getSubCategoriaInventarioAll);
/**
 * @swagger
 * /inventario/subcategoria/categoria/{categoria}:
 *   get:
 *     summary: Obtiene un SubCategoriaInventario por categoria
 *     tags: [SubCategoriaInventario]
 *     parameters:
 *       - in: path
 *         name: categoria
 *         schema:
 *           type: number
 *         required: true
 *         description: SubCategoriaInventarias por categoria
 *     responses:
 *       200:
 *         description: SubCategoriaInventario encontrado.
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/SubCategoriaInventario'
 *       404:
 *         description: SubCategoriaInventario no encontrado.
 */
router.get("/categoria/:categoria", subcategoriainventarioController.getSubCategoriaInventarioByCategoria);
/**
 * @swagger
 * /inventario/subcategoria/{id}:
 *   get:
 *     summary: Obtiene un SubCategoriaInventario por ID
 *     tags: [SubCategoriaInventario]
 *     parameters:
 *       - in: path
 *         name: id
 *         schema:
 *           type: number
 *         required: true
 *         description: ID del SubCategoriaInventario
 *     responses:
 *       200:
 *         description: SubCategoriaInventario encontrado.
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/SubCategoriaInventario'
 *       404:
 *         description: SubCategoriaInventario no encontrado.
 */
router.get("/:id", subcategoriainventarioController.getSubCategoriaInventarioById);
/**
 * @swagger
 * /inventario/subcategoria/create:
 *   post:
 *     summary: Crea un nuevo SubCategoriaInventario
 *     tags: [SubCategoriaInventario]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           schema:
 *             $ref: '#/components/schemas/SubCategoriaInventario'
 *     responses:
 *       201:
 *         description: SubCategoriaInventario creado exitosamente.
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/SubCategoriaInventario'
 */
router.post("/create", subcategoriainventarioController.createSubCategoriaInventario);
/**
 * @swagger
 * /inventario/subcategoria/update/{id}:
 *   put:
 *     summary: Actualiza un SubCategoriaInventario existente
 *     tags: [SubCategoriaInventario]
 *     parameters:
 *       - in: path
 *         name: id
 *         schema:
 *           type: number
 *         required: true
 *         description: ID del SubCategoriaInventario a actualizar
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           schema:
 *             $ref: '#/components/schemas/SubCategoriaInventario'
 *     responses:
 *       200:
 *         description: SubCategoriaInventario actualizado exitosamente.
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/SubCategoriaInventario'
 *       404:
 *         description: SubCategoriaInventario no encontrado.
 */
router.put("/update/:id", subcategoriainventarioController.updateSubCategoriaInventario);
/**
 * @swagger
 * /inventario/subcategoria/{id}:
 *   delete:
 *     summary: Elimina un SubCategoriaInventario por ID
 *     tags: [SubCategoriaInventario]
 *     parameters:
 *       - in: path
 *         name: id
 *         schema:
 *           type: number
 *         required: true
 *         description: ID del SubCategoriaInventario a eliminar
 *     responses:
 *       200:
 *         description: SubCategoriaInventario eliminado exitosamente.
 *       404:
 *         description: SubCategoriaInventario no encontrado.
 */
router.delete("/:id", subcategoriainventarioController.deleteSubCategoriaInventario);

// Rutas de filtrado individual


module.exports = router;
