const express = require("express");
const subcategoriapatrimonioController = require("../controllers/subcategoriapatrimonio.controller");

const router = express.Router();
/**
 * @swagger
 * components:
 *   schemas:
 *     SubCategoriaPatrimonio:
 *       type: object
 *       required:
 *         - Nombre
 *         - Descripcion
 *         - CategoriaPatrimonioId
 *       properties:
 *         id:
 *           type: number
 *           description: El identificador único de la SubCategoriaPatrimonio
 *         Nombre:
 *           type: string
 *           description: Nombre de la Sub Categoria
 *         Descripcion:
 *           type: string
 *           description: Descripcion de la Sub Categoria
 *         CategoriaPatrimonioId:
 *           type: number
 *           description: A que Categoria Pertenece
 *       example:
 *         id: "1"
 *         Nombre: "Monitor"
 *         Descripcion: "Pantalla de una Computadora"
 *         CategoriaPatrimonioId: "1"
 */
/**
 * @swagger
 * tags:
 *   name: SubCategoriaPatrimonio
 *   description: API para gestionar SubCategoriaPatrimonios
 */
/**
 * @swagger
 * /patrimonio/subcategoria:
 *   get:
 *     summary: Obtiene la lista de SubCategoriaPatrimonios
 *     tags: [SubCategoriaPatrimonio]
 *     responses:
 *       200:
 *         description: Lista de SubCategoriaPatrimonios.
 *         content:
 *           application/json:
 *             schema:
 *               type: array
 *               items:
 *                 $ref: '#/components/schemas/SubCategoriaPatrimonio'
 */
router.get("/", subcategoriapatrimonioController.getSubCategoriaPatrimonioAll);
/**
 * @swagger
 * /patrimonio/subcategoria/categoria/{categoria}:
 *   get:
 *     summary: Obtiene un SubCategoriaPatrimonio por ID
 *     tags: [SubCategoriaPatrimonio]
 *     parameters:
 *       - in: path
 *         name: categoria
 *         schema:
 *           type: number
 *         required: true
 *         description: SubCategorias Patrimonio por categoria
 *     responses:
 *       200:
 *         description: SubCategorias Patrimonio encontrado.
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/SubCategoriaPatrimonio'
 *       404:
 *         description: SubCategoriaPatrimonio no encontrado.
 */
router.get("/categoria/:categoria", subcategoriapatrimonioController.getSubCategoriaPatrimonioByCategoria);
/**
 * @swagger
 * /patrimonio/subcategoria/{id}:
 *   get:
 *     summary: Obtiene un SubCategoriaPatrimonio por ID
 *     tags: [SubCategoriaPatrimonio]
 *     parameters:
 *       - in: path
 *         name: id
 *         schema:
 *           type: number
 *         required: true
 *         description: ID del SubCategoriaPatrimonio
 *     responses:
 *       200:
 *         description: SubCategoriaPatrimonio encontrado.
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/SubCategoriaPatrimonio'
 *       404:
 *         description: SubCategoriaPatrimonio no encontrado.
 */
router.get("/:id", subcategoriapatrimonioController.getSubCategoriaPatrimonioById);
/**
 * @swagger
 * /patrimonio/subcategoria/create:
 *   post:
 *     summary: Crea un nuevo SubCategoriaPatrimonio
 *     tags: [SubCategoriaPatrimonio]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           schema:
 *             $ref: '#/components/schemas/SubCategoriaPatrimonio'
 *     responses:
 *       201:
 *         description: SubCategoriaPatrimonio creado exitosamente.
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/SubCategoriaPatrimonio'
 */
router.post("/create", subcategoriapatrimonioController.createSubCategoriaPatrimonio);
/**
 * @swagger
 * /patrimonio/subcategoria/update/{id}:
 *   put:
 *     summary: Actualiza un SubCategoriaPatrimonio existente
 *     tags: [SubCategoriaPatrimonio]
 *     parameters:
 *       - in: path
 *         name: id
 *         schema:
 *           type: number
 *         required: true
 *         description: ID del SubCategoriaPatrimonio a actualizar
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           schema:
 *             $ref: '#/components/schemas/SubCategoriaPatrimonio'
 *     responses:
 *       200:
 *         description: SubCategoriaPatrimonio actualizado exitosamente.
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/SubCategoriaPatrimonio'
 *       404:
 *         description: SubCategoriaPatrimonio no encontrado.
 */
router.put("/update/:id", subcategoriapatrimonioController.updateSubCategoriaPatrimonio);
/**
 * @swagger
 * /patrimonio/subcategoria/{id}:
 *   delete:
 *     summary: Elimina un SubCategoriaPatrimonio por ID
 *     tags: [SubCategoriaPatrimonio]
 *     parameters:
 *       - in: path
 *         name: id
 *         schema:
 *           type: number
 *         required: true
 *         description: ID del SubCategoriaPatrimonio a eliminar
 *     responses:
 *       200:
 *         description: SubCategoriaPatrimonio eliminado exitosamente.
 *       404:
 *         description: SubCategoriaPatrimonio no encontrado.
 */
router.delete("/:id", subcategoriapatrimonioController.deleteSubCategoriaPatrimonio);

// Rutas de filtrado individual


module.exports = router;
