const express = require("express");
const tipodocpdfController = require("../controllers/tipodocpdf.controller");

const router = express.Router();
/**
 * @swagger
 * components:
 *   schemas:
 *     TipoDocPDF:
 *       type: object
 *       required:
 *         - Nombre
 *       properties:
 *         id:
 *           type: number
 *           description: El identificador único de la TipoDocPDF
 *         Nombre:
 *           type: string
 *           description: TipoDocPDF (Titulo, Certificado, Maestria, Doctorado, Especialidad, etc)
 *       example:
 *         id: "1"
 *         Nombre: "Titulo"
 */
/**
 * @swagger
 * tags:
 *   name: TipoDocPDF
 *   description: API para gestionar TipoDocPDFs
 */
/**
 * @swagger
 * /rrhh/TipoDocPDF:
 *   get:
 *     summary: Obtiene la lista de TipoDocPDFs
 *     tags: [TipoDocPDF]
 *     responses:
 *       200:
 *         description: Lista de TipoDocPDFs.
 *         content:
 *           application/json:
 *             schema:
 *               type: array
 *               items:
 *                 $ref: '#/components/schemas/TipoDocPDF'
 */
router.get("/", tipodocpdfController.getTipoDocPDFAll);
/**
 * @swagger
 * /rrhh/TipoDocPDF/{id}:
 *   get:
 *     summary: Obtiene un TipoDocPDF por ID
 *     tags: [TipoDocPDF]
 *     parameters:
 *       - in: path
 *         name: id
 *         schema:
 *           type: number
 *         required: true
 *         description: ID del TipoDocPDF
 *     responses:
 *       200:
 *         description: TipoDocPDF encontrado.
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/TipoDocPDF'
 *       404:
 *         description: TipoDocPDF no encontrado.
 */
router.get("/:id", tipodocpdfController.getTipoDocPDFById);
/**
 * @swagger
 * /rrhh/TipoDocPDF/create:
 *   post:
 *     summary: Crea un nuevo TipoDocPDF
 *     tags: [TipoDocPDF]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           schema:
 *             $ref: '#/components/schemas/TipoDocPDF'
 *     responses:
 *       201:
 *         description: TipoDocPDF creado exitosamente.
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/TipoDocPDF'
 */
router.post("/create", tipodocpdfController.createTipoDocPDF);
/**
 * @swagger
 * /rrhh/TipoDocPDF/update/{id}:
 *   put:
 *     summary: Actualiza un TipoDocPDF existente
 *     tags: [TipoDocPDF]
 *     parameters:
 *       - in: path
 *         name: id
 *         schema:
 *           type: number
 *         required: true
 *         description: ID del TipoDocPDF a actualizar
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           schema:
 *             $ref: '#/components/schemas/TipoDocPDF'
 *     responses:
 *       200:
 *         description: TipoDocPDF actualizado exitosamente.
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/TipoDocPDF'
 *       404:
 *         description: TipoDocPDF no encontrado.
 */
router.put("/update/:id", tipodocpdfController.updateTipoDocPDF);
/**
 * @swagger
 * /rrhh/TipoDocPDF/{id}:
 *   delete:
 *     summary: Elimina un TipoDocPDF por ID
 *     tags: [TipoDocPDF]
 *     parameters:
 *       - in: path
 *         name: id
 *         schema:
 *           type: number
 *         required: true
 *         description: ID del TipoDocPDF a eliminar
 *     responses:
 *       200:
 *         description: TipoDocPDF eliminado exitosamente.
 *       404:
 *         description: TipoDocPDF no encontrado.
 */
router.delete("/:id", tipodocpdfController.deleteTipoDocPDF);

// Rutas de filtrado individual


module.exports = router;
